package ru.yandex.direct.core.entity.campaign.service.type.update

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.PlacementTypesChangeLogger
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPlacementTypes
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer
import ru.yandex.direct.model.AppliedChanges

@Component
class CampaignWithPlacementTypesUpdateOperationSupport(
    private val placementTypesChangeLogger: PlacementTypesChangeLogger
) : AbstractCampaignUpdateOperationSupport<CampaignWithPlacementTypes>() {

    override fun getTypeClass() = CampaignWithPlacementTypes::class.java

    override fun afterExecution(
        updateContainer: RestrictedCampaignsUpdateOperationContainer,
        appliedChanges: List<AppliedChanges<CampaignWithPlacementTypes>>) {
        logPlacementTypesChanges(updateContainer, appliedChanges)
    }

    private fun logPlacementTypesChanges(updateContainer: RestrictedCampaignsUpdateOperationContainer,
                                         appliedChanges: List<AppliedChanges<CampaignWithPlacementTypes>>) {
        appliedChanges.asSequence()
            .filter { it.changed(CampaignWithPlacementTypes.PLACEMENT_TYPES) }
            .forEach {
                placementTypesChangeLogger.log(
                    updateContainer.operatorUid, campaignId = it.model.id,
                    oldState = it.getOldValue(CampaignWithPlacementTypes.PLACEMENT_TYPES),
                    newState = it.getNewValue(CampaignWithPlacementTypes.PLACEMENT_TYPES)
                )
            }
    }
}
