package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithRefreshingTurbolandingMetrikaGrants;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.turbolanding.service.TurboLandingService;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.campaign.service.type.add.CampaignWithRefreshingTurbolandingMetrikaGrantsAddOperationSupport.MANAGER_SEARCH_CAMPAIGN_TYPES;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithRefreshingTurbolandingMetrikaGrantsUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithRefreshingTurbolandingMetrikaGrants> {
    private final CampaignRepository campaignRepository;
    private final TurboLandingService turboLandingService;

    @Autowired
    public CampaignWithRefreshingTurbolandingMetrikaGrantsUpdateOperationSupport(
            CampaignRepository campaignRepository,
            TurboLandingService turboLandingService) {
        this.campaignRepository = campaignRepository;
        this.turboLandingService = turboLandingService;
    }

    @Override
    public Class<CampaignWithRefreshingTurbolandingMetrikaGrants> getTypeClass() {
        return CampaignWithRefreshingTurbolandingMetrikaGrants.class;
    }

    @Override
    public void afterExecution(RestrictedCampaignsUpdateOperationContainer parameters,
                               List<AppliedChanges<CampaignWithRefreshingTurbolandingMetrikaGrants>> appliedChanges) {
        var campaigns = filterList(appliedChanges, c -> c.assigned(CommonCampaign.MANAGER_UID));
        if (campaigns.size() == 0) {
            return;
        }
        var managerUid = campaigns.get(0).getNewValue(CommonCampaign.MANAGER_UID);

        var campaignIds = mapList(campaigns,c -> c.getModel().getId());

        boolean managerHasClientCampaigns = campaignRepository
                .managerHasClientCampaignsIgnoringCurrentCampaigns(
                        parameters.getShard(), parameters.getClientId(),
                        managerUid, listToSet(campaignIds), MANAGER_SEARCH_CAMPAIGN_TYPES);

        if (!managerHasClientCampaigns) {
            /**
             * По аналогии с DIRECT-107599 и DIRECT-148701
             * Если текущая рассматриваемая кампания(кампаниии) становится сервисируемой
             * и если это первая кампания под данным мэнэджером
             */
            turboLandingService.refreshTurbolandingMetrikaGrants(parameters.getOperatorUid(), parameters.getClientId());
        }
    }
}
