package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithRestartOfConversionStrategyTimeSaving;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.AppliedChanges;

import static java.time.LocalDateTime.now;
import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.isStrategyGoalIdChanged;
import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.modifyLastBidderRestartTime;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithStrategyValidationUtils.isStrategyModelChanged;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithStrategyValidationUtils.isStrategyWithSupportOfLearningStatus;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithRestartOfConversionStrategyTimeSavingUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithRestartOfConversionStrategyTimeSaving> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithRestartOfConversionStrategyTimeSavingUpdateOperationSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithRestartOfConversionStrategyTimeSaving> getTypeClass() {
        return CampaignWithRestartOfConversionStrategyTimeSaving.class;
    }

    @Override
    public void onAppliedChangesValidated(
            RestrictedCampaignsUpdateOperationContainer updateContainer,
            List<AppliedChanges<CampaignWithRestartOfConversionStrategyTimeSaving>> appliedChanges) {

        boolean conversionStrategyLearningStatusEnabled =
                featureService.isEnabledForClientId(updateContainer.getClientId(),
                        FeatureName.CONVERSION_STRATEGY_LEARNING_STATUS_ENABLED);
        if (conversionStrategyLearningStatusEnabled) {
            LocalDateTime now = now();
            StreamEx.of(appliedChanges)
                    .forEach(changes -> modifyLastBidderRestartTimeOfStrategyIfNeed(now, changes));
        }
    }

    private static void modifyLastBidderRestartTimeOfStrategyIfNeed(
            LocalDateTime now,
            AppliedChanges<CampaignWithRestartOfConversionStrategyTimeSaving> appliedChanges) {

        boolean isStrategyWithSupportOfLearningStatus = isStrategyWithSupportOfLearningStatus(
                appliedChanges.getModel().getStrategy().getStrategyData());

        if (isStrategyWithSupportOfLearningStatus) {
            boolean isRestart = isConversionStrategyRestarting(appliedChanges);
            modifyLastBidderRestartTime(isRestart, now, appliedChanges);
        }

    }

    public static boolean isConversionStrategyRestarting(AppliedChanges<CampaignWithRestartOfConversionStrategyTimeSaving> appliedChanges) {
        boolean isAttributionModelChanged = appliedChanges.changed(
                CampaignWithRestartOfConversionStrategyTimeSaving.ATTRIBUTION_MODEL);

        boolean isStrategyGoalIdChanged = appliedChanges.changed(
                CampaignWithRestartOfConversionStrategyTimeSaving.STRATEGY)
                && isStrategyGoalIdChanged(appliedChanges);

        boolean isChangedStrategyModel =
                isStrategyModelChanged(appliedChanges.getOldValue(CampaignWithRestartOfConversionStrategyTimeSaving.STRATEGY).getStrategyData(),
                        appliedChanges.getModel().getStrategy().getStrategyData());

        boolean isOldStrategyWithoutSupportOfLearningStatus = !isStrategyWithSupportOfLearningStatus(
                appliedChanges.getOldValue(CampaignWithRestartOfConversionStrategyTimeSaving.STRATEGY).getStrategyData());

        return isAttributionModelChanged || isStrategyGoalIdChanged || isOldStrategyWithoutSupportOfLearningStatus || isChangedStrategyModel;
    }

}
