package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.balance.model.BalanceInfoQueueObjType;
import ru.yandex.direct.core.entity.balance.model.BalanceInfoQueuePriority;
import ru.yandex.direct.core.entity.balance.model.BalanceNotificationInfo;
import ru.yandex.direct.core.entity.campaign.container.CampaignAdditionalActionsContainer;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithSendingToBalance;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSendingToBalanceUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithSendingToBalance> {

    @Override
    public Class<CampaignWithSendingToBalance> getTypeClass() {
        return CampaignWithSendingToBalance.class;
    }

    @Override
    public void addToAdditionalActionsContainer(CampaignAdditionalActionsContainer additionalActionsContainer,
                                                RestrictedCampaignsUpdateOperationContainer updateParameters,
                                                List<AppliedChanges<CampaignWithSendingToBalance>> appliedChanges) {
        additionalActionsContainer.addBalanceNotificationToQueue(
                getUserOnSavingCampaignNotificationInfo(updateParameters));

        List<BalanceNotificationInfo> campaignOnChangedNameNotificationInfos =
                StreamEx.of(appliedChanges)
                        .filter(ac -> ac.changed(CommonCampaign.NAME))
                        .map(ac -> ac.getModel().getId())
                        .map(campaignId -> getCampaignOnChangedNameNotificationInfo(campaignId,
                                updateParameters.getOperatorUid()))
                        .toList();
        additionalActionsContainer.addBalanceNotificationsToQueue(campaignOnChangedNameNotificationInfos);

        List<BalanceNotificationInfo> balanceNotificationInfosOnServiced =
                StreamEx.of(appliedChanges)
                        .filter(ac -> ac.assigned(CommonCampaign.MANAGER_UID))
                        .map(ac -> getNotificationInfoOnServicedCamp(ac.getModel().getId(),
                                ac.getModel().getManagerUid())
                        ).toList();
        additionalActionsContainer.addBalanceNotificationsToQueue(balanceNotificationInfosOnServiced);
    }

    private static BalanceNotificationInfo getUserOnSavingCampaignNotificationInfo(
            RestrictedCampaignsUpdateOperationContainer updateParameters) {
        return new BalanceNotificationInfo()
                .withCidOrUid(updateParameters.getClientUid())
                .withObjType(BalanceInfoQueueObjType.UID)
                .withPriority(BalanceInfoQueuePriority.USER_ON_SAVING_CAMPAIGN)
                .withOperatorUid(updateParameters.getOperatorUid());
    }

    private static BalanceNotificationInfo getCampaignOnChangedNameNotificationInfo(Long campaignId, Long operatorUid) {
        return new BalanceNotificationInfo()
                .withCidOrUid(campaignId)
                .withObjType(BalanceInfoQueueObjType.CID)
                .withPriority(BalanceInfoQueuePriority.CAMPAIGN_ON_CHANGED_NAME)
                .withOperatorUid(operatorUid);
    }

    private static BalanceNotificationInfo getNotificationInfoOnServicedCamp(Long cid, Long managerUid) {
        return new BalanceNotificationInfo()
                .withCidOrUid(cid)
                .withObjType(BalanceInfoQueueObjType.CID)
                .withPriority(BalanceInfoQueuePriority.PRIORITY_CAMP_ON_MANAGER_CHANGED)
                .withOperatorUid(managerUid);
    }
}
