package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSimplifiedStrategyView;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstantsService;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.isAttributionModelAvailableForSimpleView;
import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.isStrategyAvailableForSimpleView;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSimplifiedStrategyViewUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithSimplifiedStrategyView> {
    private final CampaignConstantsService campaignConstantsService;

    @Autowired
    public CampaignWithSimplifiedStrategyViewUpdateOperationSupport(CampaignConstantsService campaignConstantsService) {
        this.campaignConstantsService = campaignConstantsService;
    }

    @Override
    public Class<CampaignWithSimplifiedStrategyView> getTypeClass() {
        return CampaignWithSimplifiedStrategyView.class;
    }

    @Override
    public void onAppliedChangesValidated(RestrictedCampaignsUpdateOperationContainer updateContainer,
                                          List<AppliedChanges<CampaignWithSimplifiedStrategyView>> appliedChanges) {
        StreamEx.of(appliedChanges)
                .mapToEntry(AppliedChanges::getModel)
                .removeValues(model -> isStrategyAvailableForSimpleView(model.getStrategy()) &&
                        isAttributionModelAvailableForSimpleView(model.getAttributionModel(),
                                campaignConstantsService.getDefaultAttributionModel()))
                .keys()
                .forEach(changes -> changes.modify(CampaignWithSimplifiedStrategyView.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED, false));
    }

}
