package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithTitleSubstitutionForbiddenAndEnabled;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithTitleSubstitutionForbiddenAndEnabledUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithTitleSubstitutionForbiddenAndEnabled> {
    @Override
    public Class<CampaignWithTitleSubstitutionForbiddenAndEnabled> getTypeClass() {
        return CampaignWithTitleSubstitutionForbiddenAndEnabled.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer updateContainer,
                                 List<AppliedChanges<CampaignWithTitleSubstitutionForbiddenAndEnabled>> appliedChanges) {
        appliedChanges.forEach(changes -> changes.modify(CampaignWithTitleSubstitutionForbiddenAndEnabled.HAS_TITLE_SUBSTITUTION, true));
    }
}
