package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.container.CampaignStrategyChangingSettings;
import ru.yandex.direct.core.entity.campaign.model.CpmCampaignWithPriceRecalculation;
import ru.yandex.direct.core.entity.campaign.service.pricerecalculation.CpmCampaignPriceRecalculationService;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.dbutil.model.UidClientIdShard;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.getCpmCampaignStrategyChangingSettings;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class CpmCampaignWithPriceRecalculationUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CpmCampaignWithPriceRecalculation> {

    private final CpmCampaignPriceRecalculationService cpmCampaignPriceRecalculationService;

    @Autowired
    public CpmCampaignWithPriceRecalculationUpdateOperationSupport(
            CpmCampaignPriceRecalculationService cpmCampaignPriceRecalculationService) {
        this.cpmCampaignPriceRecalculationService = cpmCampaignPriceRecalculationService;
    }

    @Override
    public Class<CpmCampaignWithPriceRecalculation> getTypeClass() {
        return CpmCampaignWithPriceRecalculation.class;
    }

    @Override
    public void updateRelatedEntitiesOutOfTransaction(
            RestrictedCampaignsUpdateOperationContainer updateContainer,
            List<AppliedChanges<CpmCampaignWithPriceRecalculation>> appliedChanges) {
        CampaignStrategyChangingSettings settings = getCpmCampaignStrategyChangingSettings(appliedChanges);

        List<AppliedChanges<CpmCampaignWithPriceRecalculation>> campaignsChangesWithChangedStrategy =
                filterList(appliedChanges, ac -> ac.changed(CpmCampaignWithPriceRecalculation.STRATEGY));
        cpmCampaignPriceRecalculationService.afterCampaignsStrategyChanged(
                campaignsChangesWithChangedStrategy,
                settings,
                updateContainer.getOperatorUid(),
                UidClientIdShard.of(updateContainer.getChiefUid(), updateContainer.getClientId(),
                        updateContainer.getShard()));
    }
}
