package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.container.CampaignStrategyChangingSettings;
import ru.yandex.direct.core.entity.campaign.model.DynamicCampaignWithPriceRecalculation;
import ru.yandex.direct.core.entity.campaign.service.pricerecalculation.DynamicCampaignPriceRecalculationService;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.dbutil.model.UidClientIdShard;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.getDynamicCampaignStrategyChangingSettings;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class DynamicCampaignWithPriceRecalculationUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<DynamicCampaignWithPriceRecalculation> {

    private final DynamicCampaignPriceRecalculationService dynamicCampaignPriceRecalculationService;

    @Autowired
    public DynamicCampaignWithPriceRecalculationUpdateOperationSupport(
            DynamicCampaignPriceRecalculationService dynamicCampaignPriceRecalculationService) {
        this.dynamicCampaignPriceRecalculationService = dynamicCampaignPriceRecalculationService;
    }

    @Override
    public Class<DynamicCampaignWithPriceRecalculation> getTypeClass() {
        return DynamicCampaignWithPriceRecalculation.class;
    }

    @Override
    public void updateRelatedEntitiesOutOfTransaction(
            RestrictedCampaignsUpdateOperationContainer updateContainer,
            List<AppliedChanges<DynamicCampaignWithPriceRecalculation>> appliedChanges) {
        CampaignStrategyChangingSettings settings = getDynamicCampaignStrategyChangingSettings(appliedChanges);

        List<AppliedChanges<DynamicCampaignWithPriceRecalculation>> campaignsChangesWithChangedStrategy =
                filterList(appliedChanges, ac -> ac.changed(DynamicCampaignWithPriceRecalculation.STRATEGY));
        dynamicCampaignPriceRecalculationService.afterCampaignsStrategyChanged(
                campaignsChangesWithChangedStrategy,
                settings,
                updateContainer.getOperatorUid(),
                UidClientIdShard.of(updateContainer.getChiefUid(), updateContainer.getClientId(),
                        updateContainer.getShard()));
    }
}
