package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.InternalAutobudgetCampaignWithCustomStrategy;
import ru.yandex.direct.core.entity.campaign.service.pricerecalculation.CommonCampaignPriceRecalculationService;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class InternalAutobudgetCampaignWithCustomStrategyUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<InternalAutobudgetCampaignWithCustomStrategy> {

    private final CommonCampaignPriceRecalculationService commonCampaignPriceRecalculationService;

    @Autowired
    public InternalAutobudgetCampaignWithCustomStrategyUpdateOperationSupport(
            CommonCampaignPriceRecalculationService commonCampaignPriceRecalculationService) {
        this.commonCampaignPriceRecalculationService = commonCampaignPriceRecalculationService;
    }

    @Override
    public Class<InternalAutobudgetCampaignWithCustomStrategy> getTypeClass() {
        return InternalAutobudgetCampaignWithCustomStrategy.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer updateContainer,
                                 List<AppliedChanges<InternalAutobudgetCampaignWithCustomStrategy>> appliedChanges) {
        // проставляем цель из стратегии в rotationGoalId
        appliedChanges.stream()
                .filter(changes -> changes.getModel().getStrategy() != null
                        && changes.getModel().getStrategy().getStrategyData() != null)
                .forEach(changes -> changes.modify(InternalAutobudgetCampaignWithCustomStrategy.ROTATION_GOAL_ID,
                        changes.getModel().getStrategy().getStrategyData().getGoalId()));
    }

    @Override
    public void updateRelatedEntitiesOutOfTransaction(
            RestrictedCampaignsUpdateOperationContainer updateContainer,
            List<AppliedChanges<InternalAutobudgetCampaignWithCustomStrategy>> appliedChanges) {
        afterCampaignsStrategyChanged(
                filterList(appliedChanges, ac -> ac.changed(InternalAutobudgetCampaignWithCustomStrategy.STRATEGY)),
                updateContainer.getOperatorUid(),
                UidAndClientId.of(updateContainer.getChiefUid(), updateContainer.getClientId()));
    }

    public void afterCampaignsStrategyChanged(
            List<AppliedChanges<InternalAutobudgetCampaignWithCustomStrategy>> appliedChanges,
            Long operatorUid,
            UidAndClientId uidAndClientId) {
        commonCampaignPriceRecalculationService.markStrategyChange(appliedChanges, operatorUid);
        commonCampaignPriceRecalculationService.mailNotification(appliedChanges, operatorUid, uidAndClientId);
    }

}
