package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaignWithCustomStrategy;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithStrategyValidationUtils;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class MobileContentCampaignWithCustomStrategyUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<MobileContentCampaignWithCustomStrategy> {

    @Override
    public Class<MobileContentCampaignWithCustomStrategy> getTypeClass() {
        return MobileContentCampaignWithCustomStrategy.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer updateContainer,
                                 List<AppliedChanges<MobileContentCampaignWithCustomStrategy>> appliedChanges) {
        StreamEx.of(appliedChanges)
                .mapToEntry(x -> x.getNewValue(MobileContentCampaignWithCustomStrategy.STRATEGY))
                .filterValues(CampaignWithStrategyValidationUtils::isCpiStrategyWithDefaultGoalId)
                .keys()
                // Для РМП кампании с CPI стратегией при выборе цели 'Установки приложения' goalId = null
                .forEach(this::clearStrategyDataGoalId);
        super.onChangesApplied(updateContainer, appliedChanges);
    }

    private void clearStrategyDataGoalId(AppliedChanges<MobileContentCampaignWithCustomStrategy> ac) {
        DbStrategy newStrategy = ac.getNewValue(MobileContentCampaignWithCustomStrategy.STRATEGY);
        newStrategy.getStrategyData()
                .withGoalId(null);
        ac.modify(MobileContentCampaignWithCustomStrategy.STRATEGY, newStrategy);
    }
}
