package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.SmartCampaignWithPriceRecalculation;
import ru.yandex.direct.core.entity.campaign.service.pricerecalculation.SmartCampaignPriceRecalculationService;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.dbutil.model.UidClientIdShard;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class SmartCampaignWithPriceRecalculationUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<SmartCampaignWithPriceRecalculation> {

    private final SmartCampaignPriceRecalculationService smartCampaignPriceRecalculationService;

    @Autowired
    public SmartCampaignWithPriceRecalculationUpdateOperationSupport(
            SmartCampaignPriceRecalculationService smartCampaignPriceRecalculationService) {
        this.smartCampaignPriceRecalculationService = smartCampaignPriceRecalculationService;
    }

    @Override
    public Class<SmartCampaignWithPriceRecalculation> getTypeClass() {
        return SmartCampaignWithPriceRecalculation.class;
    }

    @Override
    public void updateRelatedEntitiesOutOfTransaction(
            RestrictedCampaignsUpdateOperationContainer updateContainer,
            List<AppliedChanges<SmartCampaignWithPriceRecalculation>> appliedChanges) {
        int shard = updateContainer.getShard();

        List<AppliedChanges<SmartCampaignWithPriceRecalculation>> campaignsChangesWithChangedStrategy =
                filterList(appliedChanges, ac -> ac.changed(SmartCampaignWithPriceRecalculation.STRATEGY));
        smartCampaignPriceRecalculationService.afterCampaignsStrategyChanged(
                campaignsChangesWithChangedStrategy,
                UidClientIdShard.of(updateContainer.getChiefUid(), updateContainer.getClientId(), shard));
    }
}

