package ru.yandex.direct.core.entity.campaign.service.type.update.container;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.core.entity.campaign.service.RequestBasedMetrikaClientAdapter;
import ru.yandex.direct.core.entity.campaign.service.type.RestrictedCampaignsOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.type.disabled.DisabledFieldsDataContainer;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;

import static java.util.Collections.emptyMap;

/**
 * Контейнер с данными операции обновления кампании
 * {@link ru.yandex.direct.core.entity.campaign.service.RestrictedCampaignsUpdateOperation}
 */
public interface RestrictedCampaignsUpdateOperationContainer extends RestrictedCampaignsOperationContainer,
        UpdateOperationContainer<BaseCampaign>, CampaignValidationContainer {

    static RestrictedCampaignsUpdateOperationContainer create(
            int shard,
            Long operatorUid,
            ClientId clientId,
            Long uid,
            Long chiefUid) {
        return create(shard, operatorUid, clientId, uid, chiefUid, new DisabledFieldsDataContainer());
    }

    /**
     * Контейнеры - волатильные сущности. Лучше ограниченно создавать их в коде и особенно в тестах, этот метод
     * оставлен для совместимости.
     */
    static RestrictedCampaignsUpdateOperationContainer create(
            int shard,
            Long operatorUid,
            ClientId clientId,
            Long uid,
            Long chiefUid,
            DisabledFieldsDataContainer disabledFieldsDataContainer) {
        return new RestrictedCampaignsUpdateOperationContainerImpl(
                shard, operatorUid, clientId, uid, chiefUid, null, new CampaignOptions(), null, emptyMap(),
                disabledFieldsDataContainer);
    }

    static RestrictedCampaignsUpdateOperationContainer create(
            int shard,
            Long operatorUid,
            ClientId clientId,
            Long uid,
            Long chiefUid,
            CampaignOptions options,
            @Nullable RequestBasedMetrikaClientAdapter metrikaClientAdapter) {
        return create(shard, operatorUid, clientId, uid, chiefUid, options, metrikaClientAdapter,
                new DisabledFieldsDataContainer());
    }

    static RestrictedCampaignsUpdateOperationContainer create(
            int shard,
            Long operatorUid,
            ClientId clientId,
            Long uid,
            Long chiefUid,
            CampaignOptions options,
            @Nullable RequestBasedMetrikaClientAdapter metrikaClientAdapter,
            DisabledFieldsDataContainer disabledFieldsDataContainer) {
        return new RestrictedCampaignsUpdateOperationContainerImpl(
                shard, operatorUid, clientId, uid, chiefUid, metrikaClientAdapter, options, null, emptyMap(),
                disabledFieldsDataContainer);
    }

}
