package ru.yandex.direct.core.entity.campaign.service.type.update.container;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.validation.constraints.NotNull;

import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.core.entity.campaign.service.RequestBasedMetrikaClientAdapter;
import ru.yandex.direct.core.entity.campaign.service.type.AbstractRestrictedCampaignsOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.type.disabled.DisabledFieldsDataContainer;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.dbutil.model.ClientId;

import static java.util.Collections.emptyMap;
import static ru.yandex.direct.core.entity.campaign.repository.CampaignRepositoryConstants.CAMPAIGN_TYPE_TO_CLASS;

@ParametersAreNonnullByDefault
public class RestrictedCampaignsUpdateOperationContainerImpl extends AbstractRestrictedCampaignsOperationContainer
        implements RestrictedCampaignsUpdateOperationContainer {

    Map<Long, CampaignType> campaignTypeMap = new HashMap<>();
    Map<Long, Boolean> requireServicingMap = new HashMap<>();

    private Map<Long, Long> goalIdToCounterIdForCampaignsWithoutCounterIds = emptyMap();

    public RestrictedCampaignsUpdateOperationContainerImpl(
            int shard,
            Long operatorUid,
            ClientId clientId,
            Long clientUid,
            Long chiefUid,
            RequestBasedMetrikaClientAdapter metrikaClientAdapter,
            CampaignOptions options,
            @Nullable List<Long> campaignIds, // требуется при заполненном options.requireServicing
            Map<Long, BaseStrategy> clientStrategiesToLinkToAndOperationCampaignsOldStrategiesById
    ) {
        this(shard, operatorUid, clientId, clientUid, chiefUid, metrikaClientAdapter, options, campaignIds,
                clientStrategiesToLinkToAndOperationCampaignsOldStrategiesById, new DisabledFieldsDataContainer());
    }

    public RestrictedCampaignsUpdateOperationContainerImpl(
            int shard,
            Long operatorUid,
            ClientId clientId,
            Long clientUid,
            Long chiefUid,
            RequestBasedMetrikaClientAdapter metrikaClientAdapter,
            CampaignOptions options,
            @Nullable List<Long> campaignIds, // требуется при заполненном options.requireServicing
            Map<Long, BaseStrategy> clientStrategiesToLinkToAndOperationCampaignsOldStrategiesById,
            DisabledFieldsDataContainer disabledFieldsDataContainer
    ) {
        super(shard, operatorUid, clientId, clientUid, chiefUid, options, metrikaClientAdapter,
                clientStrategiesToLinkToAndOperationCampaignsOldStrategiesById, disabledFieldsDataContainer);
        List<Boolean> requireServicingList = options.getRequireServicing();
        if (requireServicingList != null) {
            EntryStream.zip(Objects.requireNonNull(campaignIds), requireServicingList)
                    .forKeyValue(requireServicingMap::put);
        }
    }

    @Override
    public boolean isCopy() {
        return options.isCopy();
    }

    public void setCampaignType(Long campaignId, CampaignType campaignType) {
        campaignTypeMap.put(campaignId, campaignType);
    }

    @Override
    public CampaignType getCampaignType(Long campaignId) {
        return campaignTypeMap.get(campaignId);
    }

    @Override
    public Class<? extends BaseCampaign> getRuntimeClass(@NotNull Long campaignId) {
        return CAMPAIGN_TYPE_TO_CLASS.get(getCampaignType(campaignId));
    }

    @Override
    public boolean skipValidateMobileApp() {
        return options.getSkipValidateMobileApp();
    }

    @Override
    public Boolean getRequireServicing(BaseCampaign campaign) {
        return requireServicingMap.get(campaign.getId());
    }

    public void setGoalIdToCounterIdForCampaignsWithoutCounterIds(
            Map<Long, Long> goalIdToCounterIdForCampaignsWithoutCounterIds) {
        this.goalIdToCounterIdForCampaignsWithoutCounterIds = goalIdToCounterIdForCampaignsWithoutCounterIds;
    }

    @Override
    public Map<Long, Long> getGoalIdToCounterIdForCampaignsWithoutCounterIds() {
        return goalIdToCounterIdForCampaignsWithoutCounterIds;
    }

}
