package ru.yandex.direct.core.entity.campaign.service.uc;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupAddOperationFactory;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperationFactory;
import ru.yandex.direct.core.entity.adgroup.service.complex.text.ComplexTextAdGroupAddOperation;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.service.CampaignOperationService;
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.core.entity.campaign.service.CampaignService;
import ru.yandex.direct.core.entity.campaign.service.RestrictedCampaignsAddOperation;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;

import static java.util.Collections.singletonList;

@Service
@ParametersAreNonnullByDefault
public class UcCampaignService {
    private final CampaignService campaignService;
    private final CampaignOperationService campaignOperationService;
    private final ComplexAdGroupAddOperationFactory complexAdGroupAddOperationFactory;
    private final ComplexAdGroupUpdateOperationFactory complexAdGroupUpdateOperationFactory;

    public UcCampaignService(CampaignService campaignService,
                             CampaignOperationService campaignOperationService,
                             ComplexAdGroupAddOperationFactory complexAdGroupAddOperationFactory,
                             ComplexAdGroupUpdateOperationFactory complexAdGroupUpdateOperationFactory) {
        this.campaignService = campaignService;
        this.campaignOperationService = campaignOperationService;
        this.complexAdGroupAddOperationFactory = complexAdGroupAddOperationFactory;
        this.complexAdGroupUpdateOperationFactory = complexAdGroupUpdateOperationFactory;
    }

    public <T extends BaseCampaign> MassResult<Long> createCampaign(T campaign, boolean isDraft,
                                           Long operatorUid, UidAndClientId uidAndClientId) {
        CampaignOptions options = new CampaignOptions.Builder()
                .withReadyToModerate(!isDraft)
                .build();
        RestrictedCampaignsAddOperation addCampaignOperation =
                campaignOperationService.createRestrictedCampaignAddOperation(
                singletonList(campaign), operatorUid, uidAndClientId,
                options);
        return addCampaignOperation.prepareAndApply();
    }

    public MassResult<Long> createGroup(ComplexTextAdGroup complexTextAdGroup, GeoTree geoTree,
                                        ShowConditionAutoPriceParams autoPriceParams,
                                        Long operatorUid, UidAndClientId uidAndClientId) {
        ComplexTextAdGroupAddOperation addGroupOperation =
                complexAdGroupAddOperationFactory.createTextAdGroupAddOperation(
                false, singletonList(complexTextAdGroup), geoTree, true, autoPriceParams,
                operatorUid, uidAndClientId.getClientId(), uidAndClientId.getUid(), DatabaseMode.ONLY_MYSQL);
        return addGroupOperation.prepareAndApply();
    }

    public <T extends BaseCampaign> MassResult<Long> updateCampaign(ModelChanges<T> modelChanges,
                                           Long operatorUid, UidAndClientId uidAndClientId) {
        var options = new CampaignOptions();
        var updateCampaignOperation = campaignOperationService
                .createRestrictedCampaignUpdateOperation(
                        singletonList(modelChanges), operatorUid, uidAndClientId, options);
        return updateCampaignOperation.apply();
    }

    public MassResult<Long> updateGroup(ComplexTextAdGroup complexTextAdGroup,
                                        Set<ModelProperty> propertiesToUpdate,
                                        GeoTree geoTree, ShowConditionAutoPriceParams autoPriceParams,
                                        Long operatorUid, UidAndClientId uidAndClientId) {
        var groupUpdateOperation = complexAdGroupUpdateOperationFactory.createRestrictedTextAdGroupUpdateOperation(
                singletonList(complexTextAdGroup), geoTree, true, autoPriceParams,
                operatorUid, uidAndClientId.getClientId(), uidAndClientId.getUid(), false, propertiesToUpdate);
        return groupUpdateOperation.prepareAndApply();
    }

    public MassResult<Long> deleteCampaigns(Long operatorUid, ClientId clientId, List<Long> campaignIds) {
        return campaignService.deleteCampaigns(campaignIds, operatorUid, clientId, Applicability.PARTIAL);
    }
}
