package ru.yandex.direct.core.entity.campaign.service.validation;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignAttributionModel;
import ru.yandex.direct.core.entity.campaign.model.CampaignWarnPlaceInterval;
import ru.yandex.direct.core.entity.campaign.model.DayBudgetShowMode;
import ru.yandex.direct.core.entity.campaign.model.EshowsRate;
import ru.yandex.direct.core.entity.campaign.model.EshowsVideoType;
import ru.yandex.direct.core.entity.campaign.model.ImpressionStandardTime;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.core.entity.time.model.TimeInterval;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.rbac.RbacRole;

import static ru.yandex.direct.rbac.RbacRole.SUPER;
import static ru.yandex.direct.utils.TextConstants.ALL;
import static ru.yandex.direct.utils.TextConstants.SPECIAL_CHARS;
import static ru.yandex.direct.utils.TimeConvertUtils.daysToSecond;

@ParametersAreNonnullByDefault
public class CampaignConstants {
    private CampaignConstants() {
    }

    private static final Set<ModelProperty<? super Campaign, ?>> SENSITIVE_PROPERTIES =
            ImmutableSet.of(
                    Campaign.STATUS_BS_SYNCED,
                    Campaign.STATUS_MODERATE,
                    Campaign.STATUS_POST_MODERATE,
                    Campaign.STATUS_SHOW,
                    Campaign.STATUS_ACTIVE,
                    Campaign.STATUS_ARCHIVED);

    public static final Set<ModelProperty<?, ?>> SENSITIVE_PROPERTIES_UNBOUNDED =
            ImmutableSet.copyOf(SENSITIVE_PROPERTIES);

    /**
     * Символы, доступные в кампаниях
     */
    private static final String ALLOW_CAMPAIGN_NAME_LETTERS_STR = ALL + SPECIAL_CHARS;

    public static final String DISALLOW_CAMPAIGN_NAME_LETTERS_RE =
            "[^" + Pattern.quote(ALLOW_CAMPAIGN_NAME_LETTERS_STR) + "]";

    public static final int MAX_CAMPAIGN_NAME_LENGTH = 255;

    public static final int MAX_NUMBER_OF_OPTIONAL_METRIKA_COUNTERS = 100;

    public static final boolean DEFAULT_ENABLE_OFFLINE_STAT_NOTICE = true;
    public static final boolean DEFAULT_ENABLE_PAUSED_BY_DAY_BUDGET_EVENT = true;
    public static final boolean DEFAULT_ENABLE_SEND_ACCOUNT_NEWS = true;
    // дефолтное значение процента остатка средств для получения предупреждения об окончании средств
    public static final Integer DEFAULT_CAMPAIGN_WARNING_BALANCE = 20;
    public static final Integer DEFAULT_INTERNAL_CAMPAIGN_WARNING_BALANCE = 10;
    // минимальное значение процента остатка средств для получения предупреждения об окончании средств
    public static final Integer MIN_CAMPAIGN_WARNING_BALANCE = 1;
    // максимальное значение процента остатка средств для получения предупреждения об окончании средств
    public static final Integer MAX_CAMPAIGN_WARNING_BALANCE = 50;

    // надо получать уведомления по кампаниям внутренней рекламы на рассылку
    public static final String INTERNAL_CAMPAIGN_EMAIL = "banana-direct-alert@yandex-team.ru";

    public static final boolean DEFAULT_ENABLE_CHECK_POSITION_EVENT = false;
    // дефолтное значение для получения уведомления о смене позиции (в минутах)
    public static final CampaignWarnPlaceInterval
            DEFAULT_CAMPAIGN_CHECK_POSITION_INTERVAL = CampaignWarnPlaceInterval._60;

    // максимальное кол-во запрещенных IP для показа
    public static final Integer MAX_DISABLED_IPS_COUNT = 25;

    public static final TimeInterval DEFAULT_SMS_TIME_INTERVAL = new TimeInterval()
            .withStartHour(9).withStartMinute(0)
            .withEndHour(21).withEndMinute(0);

    public static final long ENGAGED_SESSION_GOAL_ID = 12L;
    //goal_id для оптимизации по ключевым целям
    public static final Long MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID = 13L;
    public static final int MEANINGFUL_GOALS_MAX_COUNT = 200;

    // default цель CPI стратегии,
    // не пишется в strategyData для AUTOBUDGET_AVG_CPI
    // иначе пишется в strategyData (например для AUTOBUDGET)
    public static final Long DEFAULT_CPI_GOAL_ID = 4L;

    public static final Integer BROAD_MATCH_ALL_GOALS_ID = 0;
    public static final Integer BROAD_MATCH_LIMIT_DEFAULT = 5;
    public static final Integer BROAD_MATCH_LIMIT_MIN = 1;
    public static final Integer BROAD_MATCH_LIMIT_MAX = 100;

    public static final Integer MAX_DOMAIN_LENGTH = 255;

    public static final Integer AUTO_CONTEXT_LIMIT = 0;
    public static final Integer MAX_CONTEXT_LIMIT = 100;
    public static final Integer MIN_CONTEXT_LIMIT = 1;
    public static final Integer SHOWS_DISABLED_CONTEXT_LIMIT = 254;
    public static final Integer NO_CONTEXT_LIMIT = 255;
    public static final Integer DEFAULT_CONTEXT_LIMIT = MAX_CONTEXT_LIMIT;
    public static final Integer THE_ONLY_VALID_CONTEXT_PRICE_COEF = 100;

    public static final boolean DEFAULT_ENABLE_CPC_HOLD = true;
    public static final boolean DEFAULT_HAS_ENABLE_CPC_HOLD = true;
    public static final boolean DEFAULT_ENABLE_COMPANY_INFO = true;
    public static final boolean DEFAULT_IS_ALONE_TRAFARET_ALLOWED = false;
    public static final boolean DEFAULT_HAS_TURBO_SMARTS = false;
    public static final boolean DEFAULT_REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS = false;
    public static final boolean DEFAULT_EXCLUDE_PAUSED_COMPETING_ADS = false;
    public static final boolean DEFAULT_ADD_OPENSTAT_TAG_TO_URL = false;
    public static final boolean DEFAULT_ADD_METRIKA_TAG_TO_URL = true;
    public static final boolean DEFAULT_HAS_EXTENDED_GEO_TARGETING = true;
    public static final boolean DEFAULT_HAS_TITLE_SUBSTITUTION = true;
    public static final boolean DEFAULT_HAS_SITE_MONITORING = false;
    public static final boolean DEFAULT_ADD_TO_FAVORITES = false;
    public static final boolean DEFAULT_IS_RECOMMENDATIONS_MANAGEMENT_ENABLED = false;
    public static final boolean DEFAULT_IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED = false;
    public static final boolean DEFAULT_UAC_IS_RECOMMENDATIONS_MANAGEMENT_ENABLED = true;
    public static final boolean DEFAULT_UAC_IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED = true;

    // При сохранении и чтении из mysql приходит именно ноль со scale=2
    // Поскольку это поле используется, в том числе, в тестах, сразу ставим нужный ноль, а вне тестов хуже не станет :^)
    public static final BigDecimal DEFAULT_DAY_BUDGET = BigDecimal.valueOf(0, 2);
    public static final DayBudgetShowMode DEFAULT_DAY_BUDGET_SHOW_MODE = DayBudgetShowMode.DEFAULT_;
    public static final Integer MAX_DAY_BUDGET_DAILY_CHANGE_COUNT = 3;
    public static final Integer MAX_ALLOWED_PAGE_IDS_COUNT = 1000;

    //Strategy
    public static final Long BY_ALL_GOALS_GOAL_ID = 0L;
    public static final BigDecimal ROI_COEF_MIN = BigDecimal.ONE.negate();
    public static final BigDecimal PROFITABILITY_MIN = BigDecimal.ZERO;
    public static final BigDecimal PROFITABILITY_MAX = new BigDecimal("100");
    public static final Long RESERVE_RETURN_MIN = 0L;
    public static final Long RESERVE_RETURN_MAX = 100L;
    public static final Long RESERVE_RETURN_STEP = 10L;
    public static final Long MIN_SUFFICIENT_GOAL_CONVERSION_COUNT = 1L;
    public static final Integer PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO = 20;
    public static final Integer PAY_FOR_CONVERSION_AVG_CPA_WARNING_RATIO_DEFAULT_VALUE = 3;
    public static final Long CRR_MIN = 1L;
    public static final Long CRR_MAX = 500L;
    // список целей не из метрики, которые можно использовать на кампании
    public static final Set<Long> SPECIAL_GOAL_IDS =
            Set.of(BY_ALL_GOALS_GOAL_ID, ENGAGED_SESSION_GOAL_ID, MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID);

    // Experiments
    public static final Integer MAX_EXPERIMENTS_COUNT = 5;

    // BrandLift
    public static final Integer BRAND_LIFT_EXPERIMENT_THRESHOLD = 90;
    public static final String BRAND_LIFT_SURVEYS_LOGIN = "yndx-robot-pythia-brndlft";
    public static final int BRAND_LIFT_ID_MIN_LENGTH = 10;
    public static final int BRAND_LIFT_ID_MAX_LENGTH = 80;
    // https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/Yandex/Audience.pm?rev=5531356
    public static final long SEGMENT_GOAL_ID_SHIFT = 2500000000L;
    public static final Integer BRAND_LIFT_MIN_DAYS_CAMPAIGN_INTERVAL = 14;

    // SearchLift
    public static final Integer SEARCH_LIFT_BRANDS_MAX_SIZE = 3;
    public static final Integer SEARCH_LIFT_OBJECTS_MAX_SIZE = 5;
    public static final Integer SEARCH_LIFT_UNIT_MAX_LENGTH = 100;

    // Payment
    public static final Integer MAX_CARD_COUNT = 5;

    // Time target
    public static final int MIN_RATE_CORRECTION = 0;
    public static final int MAX_RATE_CORRECTION = 200;
    public static final int MIN_SELECTED_WORKING_HOURS = 40;
    public static final int MIN_SELECTED_HOURS_PER_WEEK = 8;

    public static final LocalTime DAILY_BUDGET_STOP_WARNING_TIME_DEFAULT = LocalTime.of(16, 0);
    public static final Duration DAILY_BUDGET_STOP_WARNING_PERIOD = Duration.ofDays(14);

    public static final CampaignAttributionModel PREVIOUS_DEFAULT_ATTRIBUTION_MODEL =
            CampaignAttributionModel.LAST_YANDEX_DIRECT_CLICK;
    public static final CampaignAttributionModel DEFAULT_ATTRIBUTION_MODEL =
            CampaignAttributionModel.LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE;

    public static final Set<RbacRole> ROLES_ALLOWED_TO_CHANGE_ATTRIBUTION_MODEL = Set.of(SUPER);
    public static final Set<RbacRole> ROLES_ALLOWED_TO_CHANGE_CONTENT_LANGUAGE = Set.of(SUPER);

    //Из Campaign.pm::MANUAL_PRICE_STRATEGIES
    public static final List<StrategyName> MANUAL_PRICE_STRATEGIES = List.of(
            StrategyName.DEFAULT_,
            StrategyName.NO_PREMIUM,
            StrategyName.CPM_DEFAULT
    );

    public static final List<Long> DEFAULT_BRAND_SAFETY_CATEGORIES = Collections.emptyList();

    public static final ImpressionStandardTime DEFAULT_IMPRESSION_STANDARD_TIME = ImpressionStandardTime.MRC;

    public static final EshowsRate DEFAULT_ESHOWS_BANNER_RATE = EshowsRate.ON;
    public static final EshowsRate DEFAULT_ESHOWS_VIDEO_RATE = EshowsRate.ON;
    public static final EshowsVideoType DEFAULT_ESHOWS_VIDEO_TYPE = EshowsVideoType.COMPLETES;

    public static final int MAX_DAYS_STRATEGY_INTERVAL = 90;
    public static final int DEFAULT_DAYS_STRATEGY_INTERVAL = 30;
    public static final int COUNT_AD_SHOWS_FOR_PRICE = 1000;

    //Метки (ppc.tag_campaign_list)
    public static final int MAX_CAMPAIGN_TAG_COUNT = 200;
    public static final int MAX_CAMPAIGN_TAG_NAME_LENGTH = 25;

    public static final long MIN_INTERNAL_CAMPAIGN_ROTATION_GOAL_ID = 3L;
    public static final long MIN_INTERNAL_CAMPAIGN_RESTRICTION_VALUE = 1L;

    // Максимальные значения для rf и rfReset
    public static final int MAX_IMPRESSION_RATE_COUNT_WITH_FEATURE = 50;
    public static final int MAX_IMPRESSION_RATE_COUNT_WITHOUT_FEATURE = 1000;
    public static final int MAX_IMPRESSION_RATE_COUNT_BANANA = 1000;
    public static final int MAX_IMPRESSION_RATE_INTERVAL_DAYS = 30;
    public static final int MAX_IMPRESSION_RATE_INTERVAL_DAYS_FOR_INTERNAL_CAMPAIGNS = 100;
    public static final int MAX_IMPRESSION_RATE_INTERVAL_DAYS_FOR_INTERNAL_CAMPAIGNS_IN_SECONDS =
            (int) daysToSecond(CampaignConstants.MAX_IMPRESSION_RATE_INTERVAL_DAYS_FOR_INTERNAL_CAMPAIGNS);

    // Используем Integer.MAX_VALUE у значений maxClicksPeriod и maxStopsPeriod как специальное значение, когда
    // период ограничений по кликам или отказам выбран на всю кампанию
    public static final int MAX_CLICKS_AND_STOPS_PERIOD_WHOLE_CAMPAIGN_VALUE = Integer.MAX_VALUE;

    public static final int MAX_BUSINESS_CATEGORY_LENGTH = 230;
    public static final int MAX_COMPANY_NAME_LENGTH = 230;

    public static final int MAX_CAMPAIGN_FIO_LENGTH = 255;

    public static final long MIN_CAMPAIGNS_PROMOTION_PERCENT = 1;
    public static final long MAX_CAMPAIGNS_PROMOTION_PERCENT = 300;
    public static final int MAX_ACTIVE_CAMPAIGNS_PROMOTIONS = 5;
    public static final int MAX_CAMPAIGNS_PROMOTIONS_PERIOD = 30;
    public static final int OLD_CAMPAIGNS_PROMOTIONS_TRESHOLD = 30;
}
