package ru.yandex.direct.core.entity.campaign.service.validation;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.direct.core.entity.campaign.model.CampaignAttributionModel;

@Service
@ParametersAreNonnullByDefault
public class CampaignConstantsService {

    private final PpcProperty<Boolean> crossDeviceDefaultAttributionTypeEnabled;

    @Autowired
    public CampaignConstantsService(PpcPropertiesSupport ppcPropertiesSupport) {
        crossDeviceDefaultAttributionTypeEnabled =
                ppcPropertiesSupport.get(PpcPropertyNames.CROSS_DEVICE_DEFAULT_ATTRIBUTION_TYPE_ENABLED,
                        Duration.ofMinutes(1));
    }

    public CampaignAttributionModel getDefaultAttributionModel() {
        return crossDeviceDefaultAttributionTypeEnabled.getOrDefault(false)
                ? CampaignConstants.DEFAULT_ATTRIBUTION_MODEL
                : CampaignConstants.PREVIOUS_DEFAULT_ATTRIBUTION_MODEL;
    }
}
