package ru.yandex.direct.core.entity.campaign.service.validation;

import ru.yandex.direct.core.validation.defects.params.CollectionSubsetDefectParams;
import ru.yandex.direct.core.validation.defects.params.ContentLanguageDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class CampaignDefectIds {

    public enum Gen implements DefectId<Void> {
        INCONSISTENT_CAMPAIGN_TYPE,

        /**
         * Запрошеная операция не поддерживается на данным типом кампании
         */
        CAMPAIGN_TYPE_NOT_SUPPORTED,

        CAMPAIGN_NO_WRITE_RIGHTS,
        CAMPAIGN_NOT_FOUND,

        /**
         * Кампания зархивирована, поэтому недоступна для модификации
         */
        ARCHIVED_CAMPAIGN_MODIFICATION,
        CAMPAIGN_WITH_MONEY_ARCHIVING,
        NON_STOPPED_CAMPAIGN_ARCHIVING,
        CAMPAIGN_ALREADY_ARCHIVED,
        CAMPAIGN_NOT_ARCHIVED,
        CAMPAIGN_IS_IN_SPECIAL_ARCHIVED_STATE,
        CAMPAIGN_ALREADY_SUSPENDED,
        CAMPAIGN_NOT_SUSPENDED,
        CANT_ADD_OR_DELETE_METRIKA_COUNTERS_TO_PERFORMANCE_CAMPAIGN,
        METRIKA_COUNTER_IS_UNAVAILABLE,
        METRIKA_COUNTERS_UNSUPPORTED_CAMP_TYPE,

        /**
         * Запрет на минус-фразы на кампаниях типа cpm_yndx_frontpage
         */
        MINUS_KEYWORDS_NOT_ALLOWED,

        WRONG_DISABLED_DOMAINS_LIMIT,

        BROAD_MATCH_DOESNT_MATCH_STRATEGY,
        RELEVANT_KEYWORDS_USELESS_FOR_CHOSEN_STRATEGY,

        OPERATOR_CANNOT_SET_CONTENT_LANGUAGE,

        DAY_BUDGET_OVERRIDEN_BY_WALLET,
        DAY_BUDGET_SHOW_MODE_OVERRIDEN_BY_WALLET,
        DAY_BUDGET_IS_ONLY_USEFUL_FOR_MANUAL_STRATEGIES,

        VIDEO_TYPE_NOT_SUPPORTED_WITH_STRATEGY,
        DAY_BUDGET_NOT_SUPPORTED_WITH_STRATEGY,

        BRAND_LIFT_CANT_BE_CHANGED,
        BRAND_LIFT_EXPERIMENT_SEGMENTS_CANT_BE_CHANGED,
        BRAND_LIFT_CAN_BE_ADDED_ONLY_TO_DRAFT_CAMPAIGN,

        OPERATOR_CANNOT_SET_ALLOWED_PAGE_IDS,
        OPERATOR_CANNOT_SET_DISALLOWED_PAGE_IDS,

        REQUIRE_SERVICING_WILL_BE_IGNORED,

        NOT_ALLOWED_ATTRIBUTION_TYPE,

        CAMPAIGNS_PROMOTIONS_PERIODS_ARE_INTERSECTED,
        CAMPAIGN_MORE_THAN_ONCE_IN_REQUEST,
        CPM_BANNER_CAMPAIGN_DISABLED
    }

    public enum Nums implements DefectId<NumberDefectParams> {
        MAX_METRIKA_COUNTERS_LIST_SIZE,
        TOO_MANY_DAY_BUDGET_DAILY_CHANGES,
        MAX_COUNT_OF_CAMPAIGNS_CREATED,
        MAX_ACTIVE_CAMPAIGNS_PROMOTIONS,
        UNARC_CAMPAIGNS_LIMIT_EXCEEDED,
    }

    public enum Places implements DefectId<String> {
        INVALID_DOMAIN_OR_SSP,
        UNKNOWN_SSP
    }

    public enum IpAddresses implements DefectId<String> {
        INVALID_IP_FORMAT,
        IP_CANT_BE_FROM_INTERNAL_NETWORK,
        IP_CANT_BE_FROM_PRIVATE_NETWORK
    }

    public enum ContentLanguage implements DefectId<ContentLanguageDefectParams> {
        BAD_LANGUAGE
    }

    public enum Subset implements DefectId<CollectionSubsetDefectParams> {
        MUST_NOT_CONTAIN_DUPLICATED_STRINGS
    }

    public enum LongSubset implements DefectId<CollectionSubsetDefectParams<Long>> {
        MUST_CONTAIN_METRIKA_COUNTERS
    }

}
