package ru.yandex.direct.core.entity.campaign.service.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.result.Path;

public interface CampaignDefectTranslations extends TranslationBundle {

    CampaignDefectTranslations INSTANCE = I18NBundle.implement(CampaignDefectTranslations.class);

    @MessageFormatStub("Значение должно быть не больше недельного бюджета.")
    Translatable weekBudgetLessThan();

    @MessageFormatStub("Значение в поле {0} должно быть не больше недельного бюджета.")
    Translatable weekBudgetLessThanDetailed(Path path);

    @MessageFormatStub("Значение средней цены клика должно быть меньше или равно максимальной ставке.")
    Translatable bidLessThanAvgBid();

    @MessageFormatStub("Нельзя одновременно задать и максимальную ставку, и среднюю цену клика.")
    Translatable avgBidAndBidTogetherAreProhibited();

    @MessageFormatStub("Процент возврата в рекламу от сэкономленного бюджета должен быть целым числом в диапазоне от " +
            "0 до 100 с шагом 10.")
    Translatable incorrectReserveReturn();

    @MessageFormatStub("Стратегия 'Пакет кликов' не поддерживается")
    Translatable weeklyClickPackageNotSupported();

    @MessageFormatStub("Стратегия совместного управления ставками не поддерживается")
    Translatable flatCpcStrategyNotSupported();

    @MessageFormatStub("Кампания добавлена в пакет. Настройки стратегии из запроса проигнорированы.")
    Translatable campaignStrategyInfoIsIgnoredOnCampaignAdd();

    @MessageFormatStub("Кампания перенесена в другой пакет. Настройки стратегии из запроса проигнорированы.")
    Translatable campaignStrategyInfoIsIgnoredOnCampaignUpdate();

    @MessageFormatStub("Новая стратегия создана в результате обновления.")
    Translatable newStrategyHasBeenCreated();

    @MessageFormatStub("Невозможно отвязать кампанию от непубличного пакета")
    Translatable campaignNotInPackage();

    @MessageFormatStub("Данная стратегия не совместима с данным типом стратегии")
    Translatable inconsistentStrategyToStrategyType();

    @MessageFormatStub("Необходимо заполнить информацию о стратегии, либо привязать кампанию к пакетной стратегии.")
    Translatable strategyInfoMissed();

    @MessageFormatStub("Запрещено добавлять в пакет кампании разных типов")
    Translatable campaignsWithDifferentTypesInOnePackage();

    @MessageFormatStub("Данная стратегия не поддерживается в этом типе кампании.")
    Translatable inconsistentStrategyToCampaignType();

    @MessageFormatStub("Данная стратегия не совместима с типами групп данной кампании.")
    Translatable inconsistentStrategyToAdGroupTypes();

    @MessageFormatStub("Данная стратегия не совместима с мобильным приложением с неизвестной трекинговой системой.")
    Translatable inconsistentStrategyToMobileCampaignWithoutTrackingSystem();

    @MessageFormatStub("Достигнуто максимальное количество кампаний - {0}")
    Translatable maxCampaignsForClientDetailed(Identity maxCampaignsForClient);

    @MessageFormatStub("Выбрана оптимизация по всем ключевым целям, но цели не заданы")
    Translatable unableToUseCurrentMeaningfulGoalsForOptimization();

    @MessageFormatStub("Получение ценности из Метрики не доступно")
    Translatable meaningfulGoalsValuesFromMetrikaNotSupported();

    @MessageFormatStub("Получение ценности из Метрики не доступно для этой стратегии")
    Translatable meaningfulGoalsValuesFromMetrikaInconsistentStrategy();

    @MessageFormatStub("Получение ценности из Метрики не доступно возможно только для всех КЦ")
    Translatable meaningfulGoalsValuesFromMetrikaAllowOnlyAllGoals();

    @MessageFormatStub("Оплата за конверсии недоступна")
    Translatable payForConversionNotSupported();

    @MessageFormatStub("Оплата за конверсии доступна только для кампаний с объявлениями, ссылающимися на " +
            "турбо-страницы")
    Translatable payForConversionDoesNotSupportBannersWithoutTurbo();

    @MessageFormatStub("Оплата за конверсии запрещена: быстрые ссылки должны ссылаться только на турбо-страницы")
    Translatable payForConversionDoesNotSupportSitelinksWithHrefs();

    @MessageFormatStub("При оплате за конверсии недопустимо использовать дневной бюджет на общем счете")
    Translatable payForConversionDoesNotAllowWalletDayBudget();

    @MessageFormatStub("Включена оплата за конверсии. Оптимизация по всем целям запрещена.")
    Translatable payForConversionDoesNotAllowAllGoals();

    @MessageFormatStub("Необходимо указать среднюю цену конверсии")
    Translatable avgCpaIsRequired();

    @MessageFormatStub("Превышено дневное ограничение на число изменений стратегии")
    Translatable strategyChangingLimitWasExceeded();

    @MessageFormatStub("Разрешено создавать не более {0} кампаний в одном запросе")
    Translatable maxCampaignsPerAddRequestDetailed(Identity maxCampaignsForClient);

    @MessageFormatStub("Разрешено изменять не более {0} кампаний в одном запросе")
    Translatable maxCampaignsPerUpdateRequestDetailed(Identity maxCampaignsForClient);

    @MessageFormatStub("Максимальный процент бюджета в Рекламной сети должен быть от 10 до 100 %")
    Translatable networkDefaultLimitPercentNotInRange();

    @MessageFormatStub("Максимальный процент бюджета в Рекламной сети должен быть кратен {0}")
    Translatable networkDefaultLimitPercentNotMultiple(Identity multiplicity);

    @MessageFormatStub("Временной таргетинг должен содержать номера дней недели от 1 до 7")
    Translatable timeTargetingDayOfTheWeekOutOfRange();

    @MessageFormatStub("Временной таргетинг содержит повторные дни недели")
    Translatable timeTargetingDayOfTheWeekContainsDuplicates();

    @MessageFormatStub("Временной таргетинг должен содержать коэффициенты ставок для каждого из 24 часов")
    Translatable timeTargetingBidsIncomplete();

    @MessageFormatStub("Временной таргетинг не может содержать отрицательные коэффициенты ставок")
    Translatable timeTargetingBidsMustNotBeNegative();

    @MessageFormatStub("Коэффициенты ставок временного таргетинга в медийной кампании должны содержать значения 0 " +
            "или 100")
    Translatable timeTargetingBidsInCpmBannerCampaignMustBeOnOrOff();

    @MessageFormatStub("Временной таргетинг должен содержать коэффициенты ставок кратные 10")
    Translatable timeTargetingBidsMustDevideTen();

    @MessageFormatStub("Коэффициенты ставок временного таргетинга должны содержать значения от 0 до 200 включительно")
    Translatable timeTargetingBidsOutOfRange();

    @MessageFormatStub("Временной таргетинг содержит не целочисленные коэффициенты ставок")
    Translatable timeTargetingBidsAreNotIntegers();

    @MessageFormatStub("HolidaysSchedule не может содержать StartHour при SuspendOnHolidays в значении YES")
    Translatable holidaysScheduleCantContainStartHourWhenSuspendOnHolidaysYes();

    @MessageFormatStub("HolidaysSchedule не может содержать EndHour при SuspendOnHolidays в значении YES")
    Translatable holidaysScheduleCantContainEndHourWhenSuspendOnHolidaysYes();

    @MessageFormatStub("HolidaysSchedule не может содержать BidPercent при SuspendOnHolidays в значении YES")
    Translatable holidaysScheduleCantContainBidPercentWhenSuspendOnHolidaysYes();

    @MessageFormatStub("Процент от ставок в выходные дни в медийной кампании должен быть равен 100%")
    Translatable holidayBidPercentMustBeOneHundredInCpmBannerCampaign();

    @MessageFormatStub("Процент от ставок в выходные дни должен быть от 10 до 200 %")
    Translatable holidayBidPercentOutOfRange();

    @MessageFormatStub("Процент от ставок в выходные дни должен быть кратен 10")
    Translatable holidayBidPercentMustDevideTen();

    @MessageFormatStub("StartHour и EndHour должны быть заданы, если не задано SuspendOnHolidays = \"YES\"")
    Translatable startHourAndEndHourMustBeSetWhenSuspendOnHolidaysNotYes();

    @MessageFormatStub("Значение поля StartHour должно быть меньше значения поля EndHour")
    Translatable startHourMustBeLessThanEndHour();

    @MessageFormatStub("StartHour должен содержать значения от 0 до 23 включительно")
    Translatable startHourOutOfRange();

    @MessageFormatStub("EndHour должен содержать значения от 1 до 24 включительно")
    Translatable endHourOutOfRange();

    @MessageFormatStub("Медийная кампания не может содержать минус-фразы")
    Translatable negativeKeywordsAreNotAllowedInCpmBannerCampaign();

    @MessageFormatStub("Дневной бюджет можно использовать только совместно с ручными стратегиями")
    Translatable dayBudgetCanBeUsedWithManualStrategiesOnly();

    @MessageFormatStub("Параметр {0} для заданной стратегии не поддерживается")
    Translatable parameterInconsistentWithStrategy(String parameter);

    @MessageFormatStub("Настройка {0} для заданной стратегии не поддерживается")
    Translatable settingInconsistentWithStrategy(String setting);

    @MessageFormatStub("Кампания не будет отправлена на сервисируемость")
    Translatable requireServicingWillBeIgnored();

    @MessageFormatStub("Значение даты в поле StartDate не может быть больше значения даты в поле EndDate")
    Translatable endDateMustBeGreaterThanOrEqualToStartDate();

    @MessageFormatStub("Дата начала периода стратегии не может быть меньше даты начала кампании")
    Translatable strategyStartDateMustBeGreaterThanOrEqualToCampaignStartDate();

    @MessageFormatStub("Дата окончания периода стратегии не может быть больше даты окончания кампании")
    Translatable strategyEndDateMustBeLessThanOrEqualToCampaignEndDate();

    @MessageFormatStub("Для стратегий с произвольным периодом, период не может быть меньше {0} дня")
    Translatable strategyPeriodDaysCountLessThanMin(Integer min);

    @MessageFormatStub("Для стратегий с произвольным периодом, период не может быть больше {0} дней")
    Translatable strategyPeriodDaysCountGreaterThanMax(Integer max);

    @MessageFormatStub("Бюджет на фиксированный период не может быть меньше {0}")
    Translatable cpmPriceIsNotGreaterThanMin(Translatable min);

    @MessageFormatStub("Бюджет на фиксированный период не может быть больше {0}")
    Translatable cpmPriceIsNotSmallerThanMax(Translatable min);

    @MessageFormatStub("Для подключения отправки межсерверных событий должно быть подключено не более чем по одной " +
            "мобильной цели для каждой ОС")
    Translatable incorrectSetOfMobileGoals();

    @MessageFormatStub("Для оптимизации по ключевым целям необходимо указать хотя бы одну ключевую цель, отличную от " +
            "вовлеченных сессий")
    Translatable toOptimizeForMeaningfulGoalAtLeastOneGoalExceptEngagedSessionIsRequired();

    @MessageFormatStub("Оптимизация по всем целям запрещена")
    Translatable allGoalsOptimizationProhibited();

    @MessageFormatStub("Поле {0} не поддерживается в кампании заданного типа")
    Translatable fieldIsNotSupportedInCampaign(String field);

    @MessageFormatStub("Настройка недельного бюджета недоступна для заданной стратегии")
    Translatable weeklyBudgetIsNotSupported();

    @MessageFormatStub("Дневной бюджет общего счета ограничивает дневной бюджет кампании")
    Translatable walletDayBudget();

    @MessageFormatStub("Режим показов общего счета перекрывает режим показов кампании")
    Translatable walletDayBudgetShowMode();

    @MessageFormatStub("Нельзя прилинковать более одной кампании к непубличной стратегии")
    Translatable linkingNonPublicStrategyToSeveralCampaigns();

    @MessageFormatStub("Ручную стратегию запрещено делать публичной")
    Translatable unavailableStrategyTypeForPublication();

    @MessageFormatStub("Стратегию без кошелька запрещено делать публичной")
    Translatable publicStrategyNotSupportedForClientsWithoutWallet();

    @MessageFormatStub("Нельзя перевести публичную кампанию в статус приватной")
    Translatable changePublicStrategyToPrivate();

    @MessageFormatStub("Для поля PriorityGoals поддерживается только операция SET")
    Translatable priorityGoalsNotSupportedOperationDetailed();

    @MessageFormatStub("Цель не задана")
    Translatable goalIdNotSet();

    @MessageFormatStub("Средняя цена клика не задана")
    Translatable averageCpcValueNotSpecified();

    @MessageFormatStub("Средняя цена конверсии не задана")
    Translatable averageCpaNotSpecified();

    @MessageFormatStub("Средняя цена установки не задана")
    Translatable averageCpiNotSpecified();

    @MessageFormatStub("Не указан процент возврата в рекламу от сэкономленного бюджета.")
    Translatable reserveReturnNotSpecified();

    @MessageFormatStub("Значение коэффициента рентабельности рекламы не заполнено (должно быть больше -1).")
    Translatable enterRoiCoefValue();

    @MessageFormatStub("Значение коэффициента рентабельности рекламы должно быть больше {0}.")
    Translatable roiCoefMustBeGreaterThanMin(Integer min);

    @MessageFormatStub("Тип кампании {0} не совпадает с указанным в запросе {1}")
    Translatable campaignTypeNotMatchesWithTypeInRequest(String typeFromDb, String typeFromRequest);

    @MessageFormatStub("Дополнительные релевантные фразы отключены")
    Translatable relevantKeywordsDisabled();

    @MessageFormatStub("При выбранной стратегии дополнительные релевантные фразы не применимы")
    Translatable relevantKeywordsUselessForChosenStrategy();

    @MessageFormatStub("Запрещено выключать все виды размещения")
    Translatable placementTypesAllDisabled();

    @MessageFormatStub("Редактирование архивной стратегии запрещено")
    Translatable archivedStrategyModificationNotAllowed();

    @MessageFormatStub("Дневной бюджет можно менять не более 3 раз в день.")
    Translatable changeDayBudgetNotMoreThan3Times();

    @MessageFormatStub("Дневной бюджет имеет смысл только для ручных стратегий")
    Translatable dailyBudgetIsOnlyUsefulForManualStrategies();

    @MessageFormatStub("Невозможно архивировать стратегию")
    Translatable strategyArchivingNotAllowed();

    @MessageFormatStub("Настройка недельного бюджета обязательна для заданной стратегии")
    Translatable weeklyBudgetIsMandatory();

    @MessageFormatStub("Достигнуто максимальное число стратегий у клиента")
    Translatable strategiesNumberLimitExceeded();

    @MessageFormatStub("Достигнуто максимальное число неархивных стратегий у клиента")
    Translatable unarchivedStrategiesNumberLimitExceeded();

    @MessageFormatStub("Достигнут лимит привязанных кампаний к пакетной стратегии")
    Translatable tooMuchCampaignsLinkedToStrategy();

    @MessageFormatStub("Оплата за показы возможна только в кампаниях с группами типа Видео")
    Translatable averageCpvStrategyIsOnlyApplicableToCampaignsWithVideoGroups();

    @MessageFormatStub("Стратегия не найдена")
    Translatable strategyNotFound();
}
