package ru.yandex.direct.core.entity.campaign.service.validation;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.validation.defects.params.CollectionSubsetDefectParams;
import ru.yandex.direct.core.validation.defects.params.ContentLanguageDefectParams;
import ru.yandex.direct.queryrec.model.Language;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_DAY_BUDGET_DAILY_CHANGE_COUNT;

public class CampaignDefects {
    public static Defect<Void> campaignTypeNotSupported() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_TYPE_NOT_SUPPORTED);
    }

    public static Defect<Void> inconsistentCampaignType() {
        return new Defect<>(CampaignDefectIds.Gen.INCONSISTENT_CAMPAIGN_TYPE);
    }

    public static Defect<Void> archivedCampaignModification() {
        return new Defect<>(CampaignDefectIds.Gen.ARCHIVED_CAMPAIGN_MODIFICATION);
    }

    public static Defect<Void> campaignWithMoneyArchiving() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_WITH_MONEY_ARCHIVING);
    }

    public static Defect<Void> nonStoppedCampaignArchiving() {
        return new Defect<>(CampaignDefectIds.Gen.NON_STOPPED_CAMPAIGN_ARCHIVING);
    }

    public static Defect<Void> campaignAlreadyArchived() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_ALREADY_ARCHIVED);
    }

    public static Defect<Void> campaignNotArchived() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_NOT_ARCHIVED);
    }

    public static Defect<Void> campaignIsInSpecialArchivedState() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_IS_IN_SPECIAL_ARCHIVED_STATE);
    }

    public static Defect<Void> campaignNoRights() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_NO_WRITE_RIGHTS);
    }

    public static Defect<Void> campaignNotFound() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_NOT_FOUND);
    }

    public static Defect<Void> campaignAlreadySuspended() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_ALREADY_SUSPENDED);
    }

    public static Defect<Void> campaignNotSuspended() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_NOT_SUSPENDED);
    }

    public static Defect<Void> cpmBannerCampaignDisabled() {
        return new Defect<>(CampaignDefectIds.Gen.CPM_BANNER_CAMPAIGN_DISABLED);
    }

    //camp_metrika_counters
    public static Defect<Void> cantAddOrDeleteMetrikaCountersToPerformanceCampaign() {
        return new Defect<>(
                CampaignDefectIds.Gen.CANT_ADD_OR_DELETE_METRIKA_COUNTERS_TO_PERFORMANCE_CAMPAIGN);
    }

    public static Defect<Void> metrikaCounterIsUnavailable() {
        return new Defect<>(CampaignDefectIds.Gen.METRIKA_COUNTER_IS_UNAVAILABLE);
    }

    public static Defect<Void> metrikaCountersUnsupportedCampType() {
        return new Defect<>(CampaignDefectIds.Gen.METRIKA_COUNTERS_UNSUPPORTED_CAMP_TYPE);
    }

    public static Defect<CollectionSubsetDefectParams<Long>> mustContainMetrikaCounters(
            Set<Long> requiredMetrikaCounters) {
        return new Defect<>(CampaignDefectIds.LongSubset.MUST_CONTAIN_METRIKA_COUNTERS,
                CollectionSubsetDefectParams.of(requiredMetrikaCounters));
    }

    public static Defect<NumberDefectParams> maxMetrikaCountersListSize(long border) {
        return new Defect<>(CampaignDefectIds.Nums.MAX_METRIKA_COUNTERS_LIST_SIZE,
                new NumberDefectParams().withMax(border));
    }

    public static Defect<NumberDefectParams> unarcCampaignsLimitExceeded(Long limit) {
        return new Defect<>(CampaignDefectIds.Nums.UNARC_CAMPAIGNS_LIMIT_EXCEEDED,
                new NumberDefectParams().withMax(limit));
    }

    public static Defect<Void> minusKeywordsNotAllowed() {
        return new Defect<>(CampaignDefectIds.Gen.MINUS_KEYWORDS_NOT_ALLOWED);
    }

    public static Defect<Void> wrongDisabledDomainLimit() {
        return new Defect<>(CampaignDefectIds.Gen.WRONG_DISABLED_DOMAINS_LIMIT);
    }

    public static Defect<String> invalidIpFormat(String ip) {
        return new Defect<>(CampaignDefectIds.IpAddresses.INVALID_IP_FORMAT, ip);
    }

    public static Defect<String> ipCantBeFromPrivateNetwork(String ip) {
        return new Defect<>(CampaignDefectIds.IpAddresses.IP_CANT_BE_FROM_PRIVATE_NETWORK, ip);
    }

    public static Defect<String> ipCantBeFromInternalNetwork(String ip) {
        return new Defect<>(CampaignDefectIds.IpAddresses.IP_CANT_BE_FROM_INTERNAL_NETWORK, ip);
    }

    public static Defect<Void> operatorCannotSetContentLanguage() {
        return new Defect<>(CampaignDefectIds.Gen.OPERATOR_CANNOT_SET_CONTENT_LANGUAGE);
    }

    public static Defect<Void> operatorCannotSetAllowedPageIds() {
        return new Defect<>(CampaignDefectIds.Gen.OPERATOR_CANNOT_SET_ALLOWED_PAGE_IDS);
    }

    public static Defect<Void> operatorCannotSetDisallowedPageIds() {
        return new Defect<>(CampaignDefectIds.Gen.OPERATOR_CANNOT_SET_DISALLOWED_PAGE_IDS);
    }

    public static Defect<Void> broadMatchDoesntMatchStrategy() {
        return new Defect<>(CampaignDefectIds.Gen.BROAD_MATCH_DOESNT_MATCH_STRATEGY);
    }

    public static Defect<Void> relevantKeywordsUselessForChosenStrategy() {
        return new Defect<>(CampaignDefectIds.Gen.RELEVANT_KEYWORDS_USELESS_FOR_CHOSEN_STRATEGY);
    }

    public static Defect<String> invalidDisabledDomain(String value) {
        return new Defect<>(CampaignDefectIds.Places.INVALID_DOMAIN_OR_SSP, value);
    }

    public static Defect<String> unknownSsp(String value) {
        return new Defect<>(CampaignDefectIds.Places.UNKNOWN_SSP, value);
    }

    public static Defect<NumberDefectParams> tooManyDayBudgetDailyChanges() {
        return new Defect<>(CampaignDefectIds.Nums.TOO_MANY_DAY_BUDGET_DAILY_CHANGES,
                new NumberDefectParams().withMax(MAX_DAY_BUDGET_DAILY_CHANGE_COUNT));
    }

    public static Defect<Void> dayBudgetOverridenByWallet() {
        return new Defect<>(CampaignDefectIds.Gen.DAY_BUDGET_OVERRIDEN_BY_WALLET);
    }

    public static Defect<Void> videoTypeNotSupportedWithStrategy() {
        return new Defect<>(CampaignDefectIds.Gen.VIDEO_TYPE_NOT_SUPPORTED_WITH_STRATEGY);
    }

    public static Defect<Void> dayBudgetShowModeOverridenByWallet() {
        return new Defect<>(CampaignDefectIds.Gen.DAY_BUDGET_SHOW_MODE_OVERRIDEN_BY_WALLET);
    }

    public static Defect<Void> dayBudgetNotSupportedWithStrategy() {
        return new Defect<>(CampaignDefectIds.Gen.DAY_BUDGET_NOT_SUPPORTED_WITH_STRATEGY);
    }

    public static Defect<Void> brandLiftCanBeAddedOnlyToDraftCampaign() {
        return new Defect<>(CampaignDefectIds.Gen.BRAND_LIFT_CAN_BE_ADDED_ONLY_TO_DRAFT_CAMPAIGN);
    }

    public static Defect<Void> brandLiftExperimentSegmentsCantBeChanged() {
        return new Defect<>(CampaignDefectIds.Gen.BRAND_LIFT_EXPERIMENT_SEGMENTS_CANT_BE_CHANGED);
    }

    public static Defect<Void> brandLiftCantBeChanged() {
        return new Defect<>(CampaignDefectIds.Gen.BRAND_LIFT_CANT_BE_CHANGED);
    }

    public static Defect<Void> notAllowedAttributionType() {
        return new Defect<>(CampaignDefectIds.Gen.NOT_ALLOWED_ATTRIBUTION_TYPE);
    }

    public static Defect inconsistentCampaignLanguageWithAdGroupGeo(Language language, Collection<Long> adGroupIds) {
        return new Defect<>(CampaignDefectIds.ContentLanguage.BAD_LANGUAGE,
                new ContentLanguageDefectParams()
                        .withLanguage(language)
                        .withAdGroupIds(adGroupIds));
    }

    public static Defect<CollectionSubsetDefectParams> duplicatedStrings(List<String> duplicatedElements) {
        return new Defect<>(CampaignDefectIds.Subset.MUST_NOT_CONTAIN_DUPLICATED_STRINGS,
                CollectionSubsetDefectParams.of(duplicatedElements));
    }

    public static Defect<NumberDefectParams> maxCampaignsForClientId(Long maxCampaigns) {
        return new Defect<>(CampaignDefectIds.Nums.MAX_COUNT_OF_CAMPAIGNS_CREATED,
                new NumberDefectParams().withMax(maxCampaigns));
    }

    public static Defect<Void> requireServicingWillBeIgnored() {
        return new Defect<>(CampaignDefectIds.Gen.REQUIRE_SERVICING_WILL_BE_IGNORED);
    }

    public static Defect<Void> campaignsPromotionsPeriodsAreIntersected() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGNS_PROMOTIONS_PERIODS_ARE_INTERSECTED);
    }

    public static Defect<NumberDefectParams> maxActiveCampaignsPromotions(long border) {
        return new Defect<>(CampaignDefectIds.Nums.MAX_ACTIVE_CAMPAIGNS_PROMOTIONS,
                new NumberDefectParams().withMax(border));
    }

    public static Defect<Void> campaignMoreThanOnceInRequest() {
        return new Defect<>(CampaignDefectIds.Gen.CAMPAIGN_MORE_THAN_ONCE_IN_REQUEST);
    }

    public static Defect<Void> dailyBudgetIsOnlyUsefulForManualStrategies() {
        return new Defect<>(CampaignDefectIds.Gen.DAY_BUDGET_IS_ONLY_USEFUL_FOR_MANUAL_STRATEGIES);
    }
}
