package ru.yandex.direct.core.entity.campaign.service.validation;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPricePackage;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.rbac.RbacRole;

@ParametersAreNonnullByDefault
public class CampaignWithPricePackageValidateBeforeApplyContext {

    // Храним User, а не RbacRole на будущее, хотим делать operator.getDeveloper() и разрешать
    // суперридер-разработчику некоторые пишущие операции, например сбрасывать бронь.
    private final User operator;
    private final Map<Long, PricePackage> pricePackagesMap;
    private final Set<String> operatorFeatures;
    private final List<CampaignWithPricePackage> campaignsWaitingApprove;

    public CampaignWithPricePackageValidateBeforeApplyContext(
            User operator,
            Map<Long, PricePackage> pricePackagesMap,
            Set<String> operatorFeatures,
            List<CampaignWithPricePackage> campaignsWaitingApprove) {
        this.operator = operator;
        this.pricePackagesMap = pricePackagesMap;
        this.operatorFeatures = operatorFeatures;
        this.campaignsWaitingApprove = campaignsWaitingApprove;
    }

    public Set<String> getOperatorFeatures() {
        return operatorFeatures;
    }

    public User getOperator() {
        return operator;
    }

    public RbacRole getOperatorRole() {
        return getOperator().getRole();
    }

    public Map<Long, PricePackage> getPricePackagesMap() {
        return pricePackagesMap;
    }

    public List<CampaignWithPricePackage> getCampaignsWaitingApprove() {
        return campaignsWaitingApprove;
    }

}
