package ru.yandex.direct.core.entity.campaign.service.validation

import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.DefectId

object CopyCampaignDefects {
    enum class Gen : DefectId<Void> {
        YND_FIXED_CURRENCY,
        ALREADY_IN_CAMPAIGN_QUEUE,
        ALREADY_IN_COPY_QUEUE,
        MUST_BE_CLIENT,
        MUST_BE_SAME_SUB_CLIENT,
        SELECTOR_NOT_ALLOWED,
        FLAG_IS_NOT_ALLOWED,
        CANNOT_COPY_DYNAMIC_FEED_ADGROUPS_BETWEEN_CLIENTS,
        CANNOT_COPY_BANNERS_WITH_REJECTED_CREATIVES,
        CANNOT_COPY_CANVAS_CREATIVES_BETWEEN_CLIENTS,
        CANNOT_COPY_CPC_VIDEO_BANNERS_BETWEEN_CLIENTS,
        CANNOT_COPY_PERMALINKS_WITHOUT_ACCESS,
    }

    @JvmStatic
    fun yndFixedCurrency(): Defect<Void> = Defect(Gen.YND_FIXED_CURRENCY)

    @JvmStatic
    fun alreadyInCampaignQueue(): Defect<Void> = Defect(Gen.ALREADY_IN_CAMPAIGN_QUEUE)

    @JvmStatic
    fun alreadyInCopyQueue(): Defect<Void> = Defect(Gen.ALREADY_IN_COPY_QUEUE)

    fun mustBeClient(): Defect<Void> = Defect(Gen.MUST_BE_CLIENT)
    fun mustBeSameSubClient(): Defect<Void> = Defect(Gen.MUST_BE_SAME_SUB_CLIENT)
    fun selectorNotAllowed(): Defect<Void> = Defect(Gen.SELECTOR_NOT_ALLOWED)
    fun flagIsNotAllowed(): Defect<Void> = Defect(Gen.FLAG_IS_NOT_ALLOWED)

    fun cannotCopyDynamicFeedAdgroupsBetweenClients(): Defect<Void> =
        Defect(Gen.CANNOT_COPY_DYNAMIC_FEED_ADGROUPS_BETWEEN_CLIENTS)

    fun cannotCopyBannersWithRejectedCreatives(): Defect<Void> =
        Defect(Gen.CANNOT_COPY_BANNERS_WITH_REJECTED_CREATIVES)

    fun cannotCopyCanvasCreativesBetweenClients(): Defect<Void> =
        Defect(Gen.CANNOT_COPY_CANVAS_CREATIVES_BETWEEN_CLIENTS)

    fun cannotCopyCpcVideoBannersBetweenClients(): Defect<Void> =
        Defect(Gen.CANNOT_COPY_CPC_VIDEO_BANNERS_BETWEEN_CLIENTS)

    fun cannotCopyPermalinksWithoutAccess(): Defect<Void> =
        Defect(Gen.CANNOT_COPY_PERMALINKS_WITHOUT_ACCESS)
}
