package ru.yandex.direct.core.entity.campaign.service.validation;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;

@FunctionalInterface
@ParametersAreNonnullByDefault
public interface PropertyChangePermission<T extends Model, C, V> {

    /**
     * Возвращает можно ли менять property. Старое значение можно найти в model, новое значение передаётся.
     * в newPropertyValue (может быть null, если property разрешает null).
     * <p>Гарантируется, что новое значение отличается от текущего (иначе метод не будет вызван).
     *
     * @param model            - модель
     * @param context          - контекст
     * @param newPropertyValue - новое значение, не совпадающее со значением из модели
     * @return                 - true, если данную property можно менять
     */
    boolean canChangeProperty(T model, C context, @Nullable V newPropertyValue);

}
