package ru.yandex.direct.core.entity.campaign.service.validation;

import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class StrategyDefects {
    private StrategyDefects() {
    }

    public static Defect<Void> weekBudgetLessThan() {
        return new Defect<>(StrategyDefectIds.Gen.WEEK_BUDGET_LESS_THAN);
    }

    public static Defect<Void> bidLessThanAvgBid() {
        return new Defect<>(StrategyDefectIds.Gen.BID_LESS_THAN_AVG_BID);
    }

    public static Defect<Void> avgBidAndBidTogetherAreProhibited() {
        return new Defect<>(StrategyDefectIds.Gen.AVG_BID_AND_BID_TOGETHER_PROHIBITED);
    }

    public static Defect<Void> incorrectReserveReturn() {
        return new Defect<>(StrategyDefectIds.Gen.INCORRECT_RESERVE_RETURN);
    }

    public static Defect<Void> campaignStrategyInfoIsIgnoredOnCampaignAdd() {
        return new Defect<>(StrategyDefectIds.Gen.CAMPAIGN_STRATEGY_INFO_IS_IGNORED_ON_CAMPAIGN_ADD);
    }

    public static Defect<Void> campaignStrategyInfoIsIgnoredOnCampaignUpdate() {
        return new Defect<>(StrategyDefectIds.Gen.CAMPAIGN_STRATEGY_INFO_IS_IGNORED_ON_CAMPAIGN_UPDATE);
    }

    public static Defect<Void> newStrategyHasBeenCreated() {
        return new Defect<>(StrategyDefectIds.Gen.NEW_STRATEGY_HAS_BEEN_CREATED);
    }

    public static Defect<Void> campaignNotInPackage() {
        return new Defect<>(StrategyDefectIds.Gen.CAMPAIGN_NOT_IN_PACKAGE);
    }

    public static Defect<Void> strategyInfoMissed() {
        return new Defect<>(StrategyDefectIds.Gen.STRATEGY_INFO_MISSED);
    }

    public static Defect<Void> campaignsWithDifferentTypesInOnePackage() {
        return new Defect<>(StrategyDefectIds.Gen.CAMPAIGNS_WITH_DIFFERENT_TYPES_IN_ONE_PACKAGE);
    }

    public static Defect<Void> inconsistentStrategyToCampaignType() {
        return new Defect<>(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_TYPE_AND_CAMPAIGN_TYPE);
    }

    public static Defect<Void> inconsistentStrategyToStrategyType() {
        return new Defect<>(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_AND_STRATEGY_TYPE);
    }

    public static Defect<Void> inconsistentStrategyToAdGroupTypes() {
        return new Defect<>(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_TYPE_AND_AD_GROUP_TYPES);
    }

    public static Defect<Void> inconsistentStrategyToMobileCampaignWithoutTrackingSystem() {
        return new Defect<>(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_TYPE_AND_MOBILE_CAMPAIGN_WITHOUT_TRACKING_SYSTEM);
    }

    public static Defect<Void> unableToUseCurrentMeaningfulGoalsForOptimization() {
        return new Defect<>(StrategyDefectIds.Gen.UNABLE_TO_USE_CURRENT_MEANINGFUL_GOALS_FOR_OPTIMIZATION);
    }

    public static Defect<Void> meaningfulGoalsValuesFromMetrikaNotSupported() {
        return new Defect<>(StrategyDefectIds.Gen.MEANINGFUL_GOALS_VALUES_FROM_METRIKA_NOT_SUPPORTED);
    }

    public static Defect<Void> meaningfulGoalsValuesFromMetrikaInconsistentStrategy() {
        return new Defect<>(StrategyDefectIds.Gen.MEANINGFUL_GOALS_VALUES_FROM_METRIKA_INCONSISTENT_STRATEGY);
    }

    public static Defect<Void> meaningfulGoalsValuesFromMetrikaAllowOnlyAllGoals() {
        return new Defect<>(StrategyDefectIds.Gen.MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ALLOW_ONLY_ALL_GOALS);
    }

    public static Defect<Void> payForConversionNotSupported() {
        return new Defect<>(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_NOT_SUPPORTED);
    }

    public static Defect<Void> payForConversionDoesNotSupportBannersWithoutTurbo() {
        return new Defect<>(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_SUPPORT_BANNERS_WITHOUT_TURBO);
    }

    public static Defect<Void> payForConversionDoesNotSupportSitelinksWithHrefs() {
        return new Defect<>(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_SUPPORT_SITELINKS_WITH_HREFS);
    }

    public static Defect<Void> payForConversionDoesNotAllowWalletDayBudget() {
        return new Defect<>(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_ALLOW_WALLET_DAY_BUDGET);
    }

    public static Defect<Void> payForConversionDoesNotAllowAllGoals() {
        return new Defect<>(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_ALLOW_ALL_GOALS);
    }

    public static Defect<Void> avgCpaIsRequired() {
        return new Defect<>(StrategyDefectIds.Gen.AVG_CPA_IS_REQUIRED);
    }

    public static Defect<Number> strategyChangingLimitWasExceeded(Integer limit) {
        return new Defect<>(StrategyDefectIds.Num.STRATEGY_CHANGING_LIMIT_WAS_EXCEEDED, limit);
    }

    public static Defect<Void> noMeaningfulGoalAvailableAfterCopy() {
        return new Defect<>(StrategyDefectIds.Gen.NO_MEANINGFUL_GOAL_AVAILABLE_AFTER_COPY);
    }

    public static Defect<Void> strategyStartDateIsBeforeCampaignStartDate() {
        return new Defect<>(StrategyDefectIds.Gen.STRATEGY_START_DATE_IS_BEFORE_CAMPAIGN_START_DATE);
    }

    public static Defect<Void> strategyEndDateIsAfterCampaignEndDate() {
        return new Defect<>(StrategyDefectIds.Gen.STRATEGY_END_DATE_IS_AFTER_CAMPAIGN_END_DATE);
    }

    public static Defect<Number> strategyPeriodDaysCountLessThanMin(Integer min) {
        return new Defect<>(StrategyDefectIds.Num.STRATEGY_PERIOD_DAYS_COUNT_LESS_THAN_MIN, min);
    }

    public static Defect<Number> strategyPeriodDaysCountMoreThanMax(Integer max) {
        return new Defect<>(StrategyDefectIds.Num.STRATEGY_PERIOD_DAYS_COUNT_GREATER_THAN_MAX, max);
    }

    public static Defect<Void> incorrectSetOfMobileGoals() {
        return new Defect<>(StrategyDefectIds.Gen.INCORRECT_SET_OF_MOBILE_GOALS);
    }

    public static Defect<Void> allGoalsOptimizationProhibited() {
        return new Defect<>(StrategyDefectIds.Gen.ALL_GOALS_OPTIMIZATION_PROHIBITED);
    }

    public static Defect<Void> weekBudgetIsNotSupported() {
        return new Defect<>(StrategyDefectIds.Gen.WEEKLY_BUDGET_IS_NOT_SUPPORTED);
    }

    public static Defect<Void> unavailableStrategyTypeForPublication() {
        return new Defect<>(StrategyDefectIds.Gen.UNAVAILABLE_STRATEGY_TYPE_FOR_PUBLICATION);
    }

    public static Defect<Void> publicStrategyNotSupportedForClientsWithoutWallet() {
        return new Defect<>(StrategyDefectIds.Gen.PUBLIC_STRATEGY_NOT_SUPPORTED_FOR_CLIENTS_WITHOUT_WALLET);
    }

    public static Defect<Void> linkingNonPublicStrategyToSeveralCampaigns() {
        return new Defect<>(StrategyDefectIds.Gen.LINKING_NON_PUBLIC_STRATEGY_TO_SEVERAL_CAMPAIGNS);
    }

    public static Defect<Void> changePublicStrategyToPrivate() {
        return new Defect<>(StrategyDefectIds.Gen.CHANGE_PUBLIC_STRATEGY_TO_PRIVATE);
    }

    public static Defect<Void> flatCpcStrategyNotSupported() {
        return new Defect<>(StrategyDefectIds.Gen.FLAT_CPC_STRATEGY_NOT_SUPPORTED);
    }

    public static Defect<Void> archivedStrategyModification() {
        return new Defect<>(StrategyDefectIds.Gen.ARCHIVED_STRATEGY_MODIFICATION);
    }

    public static Defect<Void> strategyArchivingNotAllowed() {
        return new Defect<>(StrategyDefectIds.Gen.STRATEGY_ARCHIVING_NOT_ALLOWED);
    }

    public static Defect<Void> weekBudgetIsMandatory() {
        return new Defect<>(StrategyDefectIds.Gen.WEEKLY_BUDGET_IS_MANDATORY);
    }

    public static Defect strategiesNumberLimitExceeded(int max) {
        return new Defect<>(StrategyDefectIds.NumParameters.STRATEGIES_NUMBER_LIMIT_EXCEEDED,
                new NumberDefectParams().withMax(max));
    }

    public static Defect unarchivedStrategiesNumberLimitExceeded(int max) {
        return new Defect<>(StrategyDefectIds.NumParameters.UNARCHIVED_STRATEGIES_NUMBER_LIMIT_EXCEEDED,
                new NumberDefectParams().withMax(max));
    }

    public static Defect<Number> tooMuchCampaignsLinkedToStrategy(Integer limit) {
        return new Defect<>(StrategyDefectIds.Num.TOO_MUCH_CAMPAIGNS_LINKED_TO_STRATEGY, limit);
    }

    public static Defect<Void> strategyNotFound() {
        return new Defect<>(StrategyDefectIds.Gen.STRATEGY_NOT_FOUND);
    }

}
