package ru.yandex.direct.core.entity.campaign.service.validation.type;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierInventory;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierInventoryAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.InventoryType;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBidModifiers;
import ru.yandex.direct.operation.tree.TreeOperationUtils;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.validation.result.PathHelper.index;

@ParametersAreNonnullByDefault
public class CampaignWithBidModifiersUtils {
    public static void transferValidationResult(ValidationResult<List<CampaignWithBidModifiers>, Defect> vr,
                                                List<CampaignWithBidModifiers> campaigns,
                                                ValidationResult<List<BidModifier>, Defect> bidModifiersVr,
                                                Integer campaignIndex,
                                                List<Integer> bidModifiersIndexes) {
        CampaignWithBidModifiers campaign = campaigns.get(campaignIndex);

        var campaignVr = vr.getOrCreateSubValidationResult(index(campaignIndex), campaign);

        var destBidModifiersVr = campaignVr.getOrCreateSubValidationResult(CampaignWithBidModifiers.BID_MODIFIERS,
                campaign.getBidModifiers());

        Map<Integer, Integer> destToSourceIndexMap = EntryStream.of(bidModifiersIndexes).toMap();

        TreeOperationUtils.mergeSubListValidationResults(destBidModifiersVr, bidModifiersVr, destToSourceIndexMap);
    }

    public static Multimap<Integer, Integer> getMultimap(Map<Integer, List<Integer>> indexMap) {
        Multimap<Integer, Integer> indexMultiMap = HashMultimap.create();
        indexMap.forEach(indexMultiMap::putAll);
        return indexMultiMap;
    }

    public static Map<Integer, List<Integer>> getBidModifiersIndexesByCampaignIndex(
            List<CampaignWithBidModifiers> campaigns,
            List<BidModifier> bidModifiers) {

        Map<BidModifier, Integer> indexByBidModifier = EntryStream.of(bidModifiers)
                .invert()
                .toMap();

        return EntryStream.of(campaigns)
                .mapValues(CampaignWithBidModifiers::getBidModifiers)
                .nonNullValues()
                .flatMapValues(Collection::stream)
                .mapValues(indexByBidModifier::get)
                .grouping();
    }

    public static void addInBannerToInAppBidModifiers(List<BidModifier> allBidModifiers) {
        if (allBidModifiers == null || allBidModifiers.isEmpty()) {
            return;
        }
        var bidModifier = allBidModifiers.stream()
                .filter(bm -> bm.getType() == BidModifierType.INVENTORY_MULTIPLIER)
                .findFirst();

        if(!bidModifier.isPresent()) {
            return;
        }
        BidModifierInventory bidModifierInventory = (BidModifierInventory)(bidModifier.get());
        var adjustments = filterList(bidModifierInventory.getInventoryAdjustments(),
                adj -> adj.getInventoryType() == InventoryType.INAPP ||
                        adj.getInventoryType() == InventoryType.INBANNER);
        if (adjustments.size() == 1) {
            BidModifierInventoryAdjustment bmia = adjustments.get(0);
            bidModifierInventory.getInventoryAdjustments().add(
                    new BidModifierInventoryAdjustment()
                            .withInventoryType((bmia.getInventoryType() == InventoryType.INAPP) ?
                                    InventoryType.INBANNER : InventoryType.INAPP)
                            .withPercent(bmia.getPercent()));
        }

    }

}
