package ru.yandex.direct.core.entity.campaign.service.validation.type;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPricePackage;

@ParametersAreNonnullByDefault
public class CampaignWithPricePackageValidationUtils {

    public static Set<Long> extractPricePackageIds(Collection<CampaignWithPricePackage> campaigns) {
        return campaigns.stream()
                .map(CampaignWithPricePackage::getPricePackageId)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());
    }

}
