package ru.yandex.direct.core.entity.campaign.service.validation.type

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.mobileapp.model.MobileApp
import ru.yandex.direct.core.entity.mobileapp.service.MobileAppService
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContent
import ru.yandex.direct.core.entity.mobilecontent.service.MobileContentService
import ru.yandex.direct.dbutil.model.ClientId

@Service
class MobileContentServiceHelper(
    private val mobileAppService: MobileAppService,
    private val mobileContentService: MobileContentService
) {

    fun getMobileContents(clientId: ClientId, mobileAppIds: Set<Long>): List<MobileContent> {
        val mobileApps = mobileAppService.getMobileApps(clientId, mobileAppIds)
        val mobileContentIds = mobileApps.map(MobileApp::getMobileContentId)

        return mobileContentService.getMobileContent(clientId, mobileContentIds)
    }

    fun getMobileApp(clientId: ClientId, mobileAppId: Long): MobileApp? {
        return mobileAppService.getMobileApp(clientId, mobileAppId).orElse(null);
    }
}
