package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignForbiddenOnTouch;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@Component
@ParametersAreNonnullByDefault
public class CampaignForbiddenOnTouchAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignForbiddenOnTouch> {

    @Autowired
    public CampaignForbiddenOnTouchAddValidationTypeSupport() {
    }

    @Override
    public Class<CampaignForbiddenOnTouch> getTypeClass() {
        return CampaignForbiddenOnTouch.class;
    }

    @Override
    public ValidationResult<List<CampaignForbiddenOnTouch>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignForbiddenOnTouch>, Defect> vr
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> {
                    var vb = ModelItemValidationBuilder.of(campaign);
                    vb.item(CampaignForbiddenOnTouch.IS_TOUCH).check(isNull());
                    return vb.getResult();
                })
                .getResult();
    }

}
