package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignSupportedOnTouch;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignSupportedOnTouchValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignSupportedOnTouchAddValidationTypeSupport extends
        AbstractCampaignAddValidationTypeSupport<CampaignSupportedOnTouch> {

    private final FeatureService featureService;

    @Autowired
    public CampaignSupportedOnTouchAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignSupportedOnTouch> getTypeClass() {
        return CampaignSupportedOnTouch.class;
    }

    @Override
    public ValidationResult<List<CampaignSupportedOnTouch>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignSupportedOnTouch>, Defect> vr) {

        boolean isTouchDirectEnabled = featureService.isEnabledForClientId(container.getClientId(),
                FeatureName.TOUCH_DIRECT_ENABLED);
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new CampaignSupportedOnTouchValidator(isTouchDirectEnabled).apply(campaign))
                .getResult();
    }

}
