package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataBusinessCategory;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithAdditionalDataBusinessCategoryValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAdditionalDataBusinessCategoryAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithAdditionalDataBusinessCategory> {

    @Autowired
    CampaignWithAdditionalDataBusinessCategoryAddValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithAdditionalDataBusinessCategory> getTypeClass() {
        return CampaignWithAdditionalDataBusinessCategory.class;
    }

    @Override
    public ValidationResult<List<CampaignWithAdditionalDataBusinessCategory>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithAdditionalDataBusinessCategory>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithAdditionalDataBusinessCategoryValidator())
                .getResult();
    }
}
