package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataCompanyName;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithAdditionalDataCompanyNameValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAdditionalDataCompanyNameAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithAdditionalDataCompanyName> {

    @Autowired
    CampaignWithAdditionalDataCompanyNameAddValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithAdditionalDataCompanyName> getTypeClass() {
        return CampaignWithAdditionalDataCompanyName.class;
    }

    @Override
    public ValidationResult<List<CampaignWithAdditionalDataCompanyName>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithAdditionalDataCompanyName>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithAdditionalDataCompanyNameValidator())
                .getResult();
    }
}
