package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdvancedGeoTargeting;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithAdvancedGeoTargetingValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAdvancedGeoTargetingAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithAdvancedGeoTargeting> {
    private final FeatureService featureService;

    public CampaignWithAdvancedGeoTargetingAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithAdvancedGeoTargeting> getTypeClass() {
        return CampaignWithAdvancedGeoTargeting.class;
    }

    @Override
    public ValidationResult<List<CampaignWithAdvancedGeoTargeting>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithAdvancedGeoTargeting>, Defect> vr) {

        var vb = new ListValidationBuilder<>(vr);
        var advancedGeoTargeting = featureService.isEnabledForClientId(container.getClientId(), FeatureName.ADVANCED_GEOTARGETING);

        vb.checkEachBy(campaign -> new CampaignWithAdvancedGeoTargetingValidator(advancedGeoTargeting).apply(campaign));
        return vb.getResult();
    }
}
