package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedOnAdultContent;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithAllowedOnAdultContentValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAllowedOnAdultContentAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithAllowedOnAdultContent> {

    private final FeatureService featureService;

    public CampaignWithAllowedOnAdultContentAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithAllowedOnAdultContent> getTypeClass() {
        return CampaignWithAllowedOnAdultContent.class;
    }

    @Override
    public ValidationResult<List<CampaignWithAllowedOnAdultContent>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithAllowedOnAdultContent>, Defect> vr
    ) {
        boolean isAllowedOnAdultContentEnabled = featureService.isEnabledForClientId(
                container.getClientId(), FeatureName.CAMPAIGN_ALLOWED_ON_ADULT_CONTENT);

        return new ListValidationBuilder<>(vr)
                .checkEachBy(
                        campaign -> new CampaignWithAllowedOnAdultContentValidator(isAllowedOnAdultContentEnabled)
                                .apply(campaign),
                        When.isFalse(container.isCopy()))
                .getResult();
    }
}
