package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedOnAdultContentForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithAllowedOnAdultContentForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAllowedOnAdultContentForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithAllowedOnAdultContentForbidden> {

    @Override
    public Class<CampaignWithAllowedOnAdultContentForbidden> getTypeClass() {
        return CampaignWithAllowedOnAdultContentForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithAllowedOnAdultContentForbidden>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithAllowedOnAdultContentForbidden>, Defect> vr
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithAllowedOnAdultContentForbiddenValidator())
                .getResult();
    }
}
