package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Multimap;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBidModifiers;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.campaign.service.validation.type.CampaignWithBidModifiersUtils.getBidModifiersIndexesByCampaignIndex;
import static ru.yandex.direct.core.entity.campaign.service.validation.type.CampaignWithBidModifiersUtils.getMultimap;
import static ru.yandex.direct.core.entity.campaign.service.validation.type.CampaignWithBidModifiersUtils.transferValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBidModifiersAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithBidModifiers> {
    private final ComplexBidModifierService complexBidModifierService;

    public CampaignWithBidModifiersAddValidationTypeSupport(ComplexBidModifierService complexBidModifierService) {
        this.complexBidModifierService = complexBidModifierService;
    }

    @Override
    public Class<CampaignWithBidModifiers> getTypeClass() {
        return CampaignWithBidModifiers.class;
    }

    @Override
    public ValidationResult<List<CampaignWithBidModifiers>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithBidModifiers>, Defect> vr) {
        List<CampaignWithBidModifiers> campaigns = vr.getValue();

        Map<Integer, CampaignType> campaignTypeByIndex = EntryStream.of(campaigns)
                .mapValues(CampaignWithBidModifiers::getType)
                .toMap();

        List<BidModifier> bidModifiers = StreamEx.of(campaigns)
                .flatCollection(CampaignWithBidModifiers::getBidModifiers)
                .nonNull()
                .toList();

        Map<Integer, List<Integer>> bidModifiersIndexesByCampaignIndex =
                getBidModifiersIndexesByCampaignIndex(campaigns, bidModifiers);
        Multimap<Integer, Integer> indexMultimap = getMultimap(bidModifiersIndexesByCampaignIndex);

        Map<Integer, CampaignType> campaignTypeByBidModifierIndex = EntryStream.of(bidModifiersIndexesByCampaignIndex)
                .flatMapValues(Collection::stream)
                .invert()
                .mapValues(campaignTypeByIndex::get)
                .toMap();

        var bidModifiersVr = complexBidModifierService.validateBidModifiersFlat(bidModifiers, indexMultimap,
                campaignTypeByBidModifierIndex::get, index -> null, container.getClientId());

        bidModifiersIndexesByCampaignIndex.forEach((campaignIndex, bidModifiersIndexes) ->
                transferValidationResult(vr, campaigns, bidModifiersVr, campaignIndex, bidModifiersIndexes));
        return vr;
    }
}
