package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandLiftHiddenForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithBrandLiftHiddenForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBrandLiftHiddenForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithBrandLiftHiddenForbidden> {

    @Override
    public Class<CampaignWithBrandLiftHiddenForbidden> getTypeClass() {
        return CampaignWithBrandLiftHiddenForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithBrandLiftHiddenForbidden>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithBrandLiftHiddenForbidden>, Defect> vr
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithBrandLiftHiddenForbiddenValidator(),
                        When.isFalse(container.isCopy()))
                .getResult();
    }
}
