package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBroadMatch;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithBroadMatchPreValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithBroadMatchValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBroadMatchAddValidationTypeSupport extends AbstractCampaignAddValidationTypeSupport<CampaignWithBroadMatch> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithBroadMatchAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithBroadMatch> getTypeClass() {
        return CampaignWithBroadMatch.class;
    }

    @Override
    public ValidationResult<List<CampaignWithBroadMatch>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithBroadMatch>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);

        vb.checkEachBy(new CampaignWithBroadMatchPreValidator());

        return vb.getResult();
    }

    @Override
    public ValidationResult<List<CampaignWithBroadMatch>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithBroadMatch>, Defect> vr) {

        var vb = new ListValidationBuilder<>(vr);

        vb.checkEachBy(campaign -> CampaignWithBroadMatchValidator
                .build(Set.of())
                .apply(campaign));

        return vb.getResult();
    }
}
