package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithContentLanguage;
import ru.yandex.direct.core.validation.defects.RightsDefects;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.ROLES_ALLOWED_TO_CHANGE_CONTENT_LANGUAGE;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithContentLanguageAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithContentLanguage> {

    @Override
    public Class<CampaignWithContentLanguage> getTypeClass() {
        return CampaignWithContentLanguage.class;
    }

    private static class CampaignWithContentLanguageValidator implements Validator<CampaignWithContentLanguage, Defect> {
        private final RbacRole operatorRole;

        private CampaignWithContentLanguageValidator(RbacRole operatorRole) {
            this.operatorRole = operatorRole;
        }

        public static CampaignWithContentLanguageValidator build(RbacRole operatorRole) {
            return new CampaignWithContentLanguageValidator(operatorRole);
        }

        @Override
        public ValidationResult<CampaignWithContentLanguage, Defect> apply(
                CampaignWithContentLanguage campaignWithContentLanguage) {
            ModelItemValidationBuilder<CampaignWithContentLanguage> vb =
                    ModelItemValidationBuilder.of(campaignWithContentLanguage);
            vb.item(CampaignWithContentLanguage.CONTENT_LANGUAGE)
                    .check(Constraint.fromPredicate(
                            attributionModel -> ROLES_ALLOWED_TO_CHANGE_CONTENT_LANGUAGE.contains(operatorRole),
                            RightsDefects.noRights()), When.notNull());

            return vb.getResult();
        }
    }
}
