package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomStrategyAndCustomDayBudget;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithCustomStrategyAndCustomDayBudgetValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCustomStrategyAndCustomDayBudgetAddValidationTypeSupport extends
        AbstractCampaignAddValidationTypeSupport<CampaignWithCustomStrategyAndCustomDayBudget> {
    @Override
    public Class<CampaignWithCustomStrategyAndCustomDayBudget> getTypeClass() {
        return CampaignWithCustomStrategyAndCustomDayBudget.class;
    }

    @Override
    public ValidationResult<List<CampaignWithCustomStrategyAndCustomDayBudget>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithCustomStrategyAndCustomDayBudget>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new CampaignWithCustomStrategyAndCustomDayBudgetValidator().apply(campaign))
                .getResult();
    }

}
