package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDialog;
import ru.yandex.direct.core.entity.campaign.model.Dialog;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithDialogValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.dialogs.service.DialogsService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDialogAddValidationTypeSupport extends AbstractCampaignAddValidationTypeSupport<CampaignWithDialog> {
    private final DialogsService dialogsService;

    @Autowired
    public CampaignWithDialogAddValidationTypeSupport(DialogsService dialogsService) {
        this.dialogsService = dialogsService;
    }

    @Override
    public Class<CampaignWithDialog> getTypeClass() {
        return CampaignWithDialog.class;
    }

    @Override
    public ValidationResult<List<CampaignWithDialog>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithDialog>, Defect> vr) {
        Set<Long> availableDialogs = listToSet(dialogsService.getDialogsByClientId(container.getClientId()), Dialog::getId);
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithDialogValidator(availableDialogs))
                .getResult();
    }
}
