package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledDomainsAndSsp;
import ru.yandex.direct.core.entity.campaign.service.validation.DisableDomainValidationService;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithDisabledDomainsAndSspValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.client.model.ClientLimits;
import ru.yandex.direct.core.entity.client.service.ClientLimitsService;
import ru.yandex.direct.core.entity.sspplatform.repository.SspPlatformsRepository;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisabledDomainsAndSspAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithDisabledDomainsAndSsp> {
    private final SspPlatformsRepository sspPlatformsRepository;
    private final ClientLimitsService clientLimitsService;
    private final DisableDomainValidationService disableDomainValidationService;

    public CampaignWithDisabledDomainsAndSspAddValidationTypeSupport(SspPlatformsRepository sspPlatformsRepository,
                                                                     ClientLimitsService clientLimitsService,
                                                                     DisableDomainValidationService disableDomainValidationService) {
        this.sspPlatformsRepository = sspPlatformsRepository;
        this.clientLimitsService = clientLimitsService;
        this.disableDomainValidationService = disableDomainValidationService;
    }

    @Override
    public Class<CampaignWithDisabledDomainsAndSsp> getTypeClass() {
        return CampaignWithDisabledDomainsAndSsp.class;
    }

    @Override
    public ValidationResult<List<CampaignWithDisabledDomainsAndSsp>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithDisabledDomainsAndSsp>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);


        ClientLimits clientLimits = clientLimitsService.getClientLimits(container.getClientId());
        int generalBlacklistSizeLimit = clientLimits.getGeneralBlacklistSizeLimitOrDefault().intValue();

        vb.checkEachBy(campaign -> new CampaignWithDisabledDomainsAndSspValidator(sspPlatformsRepository,
                container.getClientId(), generalBlacklistSizeLimit, disableDomainValidationService)
                .apply(campaign));
        return vb.getResult();
    }
}
