package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisallowedPageIds;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithDisallowedPageIdsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisallowedPageIdsAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithDisallowedPageIds> {

    @Override
    public Class<CampaignWithDisallowedPageIds> getTypeClass() {
        return CampaignWithDisallowedPageIds.class;
    }

    @Override
    public ValidationResult<List<CampaignWithDisallowedPageIds>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithDisallowedPageIds>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithDisallowedPageIdsValidator())
                .getResult();
    }

}
