package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCompanyInfoForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEnableCompanyInfoForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithEnableCompanyInfoForbidden> {

    @Autowired
    public CampaignWithEnableCompanyInfoForbiddenAddValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithEnableCompanyInfoForbidden> getTypeClass() {
        return CampaignWithEnableCompanyInfoForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithEnableCompanyInfoForbidden>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithEnableCompanyInfoForbidden>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> {
                    var vb = ModelItemValidationBuilder.of(campaign);
                    vb.item(CampaignWithEnableCompanyInfoForbidden.ENABLE_COMPANY_INFO)
                            .check(isNull());
                    return vb.getResult();
                })
                .getResult();
    }

}
