package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCpcHoldForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEnableCpcHoldForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithEnableCpcHoldForbidden> {

    @Autowired
    public CampaignWithEnableCpcHoldForbiddenAddValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithEnableCpcHoldForbidden> getTypeClass() {
        return CampaignWithEnableCpcHoldForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithEnableCpcHoldForbidden>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithEnableCpcHoldForbidden>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> {
                    var vb = ModelItemValidationBuilder.of(campaign);
                    vb.item(CampaignWithEnableCpcHoldForbidden.ENABLE_CPC_HOLD)
                            .check(isNull());
                    return vb.getResult();
                })
                .getResult();
    }

}
