package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithExtendedGeoTargetingForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithExtendedGeoTargetingForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithExtendedGeoTargetingForbidden> {

    @Autowired
    public CampaignWithExtendedGeoTargetingForbiddenAddValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithExtendedGeoTargetingForbidden> getTypeClass() {
        return CampaignWithExtendedGeoTargetingForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithExtendedGeoTargetingForbidden>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithExtendedGeoTargetingForbidden>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> {
                    var vb = ModelItemValidationBuilder.of(campaign);
                    vb.item(CampaignWithExtendedGeoTargetingForbidden.HAS_EXTENDED_GEO_TARGETING)
                            .check(isNull());
                    return vb.getResult();
                })
                .getResult();
    }

}
