package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithFixedTimeTargeting;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithFixedTimeTargetingAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithFixedTimeTargeting> {

    @Autowired
    public CampaignWithFixedTimeTargetingAddValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithFixedTimeTargeting> getTypeClass() {
        return CampaignWithFixedTimeTargeting.class;
    }

    @Override
    public ValidationResult<List<CampaignWithFixedTimeTargeting>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithFixedTimeTargeting>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(timeTargetingValidator())
                .getResult();
    }

    private static Validator<CampaignWithFixedTimeTargeting, Defect> timeTargetingValidator() {
        return campaign -> {
            ModelItemValidationBuilder<CampaignWithFixedTimeTargeting> vb = ModelItemValidationBuilder.of(campaign);
            // фронтэнд должен прислать timeZone, т.к. timeZone приходит с пользовательских настроек
            // и не должен присылать timeTarget, т.к. timeTarget мы заполним сами
            vb.item(CampaignWithFixedTimeTargeting.TIME_TARGET)
                    .check(isNull());
            vb.item(CampaignWithFixedTimeTargeting.TIME_ZONE_ID)
                    .check(notNull());
            return vb.getResult();
        };
    }

}
