package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithForbiddenCheckPositionEvent;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithForbiddenCheckPositionEventAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithForbiddenCheckPositionEvent> {

    @Override
    public Class<CampaignWithForbiddenCheckPositionEvent> getTypeClass() {
        return CampaignWithForbiddenCheckPositionEvent.class;
    }

    @Override
    public ValidationResult<List<CampaignWithForbiddenCheckPositionEvent>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithForbiddenCheckPositionEvent>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);

        vb.checkEachBy(c -> new CampaignWithoutCheckPositionEventPreValidator(container).apply(c));
        return vb.getResult();
    }

    private static class CampaignWithoutCheckPositionEventPreValidator
            implements Validator<CampaignWithForbiddenCheckPositionEvent, Defect> {

        private final CampaignValidationContainer container;

        CampaignWithoutCheckPositionEventPreValidator(CampaignValidationContainer container) {
            this.container = container;
        }

        @Override
        public ValidationResult<CampaignWithForbiddenCheckPositionEvent, Defect> apply(
                CampaignWithForbiddenCheckPositionEvent campaign) {
            ModelItemValidationBuilder<CampaignWithForbiddenCheckPositionEvent> vb =
                    ModelItemValidationBuilder.of(campaign);
            if (!container.getOptions().isForceEnableCheckPositionEvent()) {
                vb.item(CampaignWithForbiddenCheckPositionEvent.ENABLE_CHECK_POSITION_EVENT)
                        .check(isNull());
            }
            if (!container.getOptions().isForceCheckPositionIntervalEvent()) {
                vb.item(CampaignWithForbiddenCheckPositionEvent.CHECK_POSITION_INTERVAL_EVENT)
                        .check(isNull());
            }
            return vb.getResult();
        }
    }
}
