package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithFrontpageTypes;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithFrontpageTypesValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithFrontpageTypesAddValidationTypeSupport extends AbstractCampaignAddValidationTypeSupport<CampaignWithFrontpageTypes> {

    @Override
    public Class<CampaignWithFrontpageTypes> getTypeClass() {
        return CampaignWithFrontpageTypes.class;
    }

    @Override
    public ValidationResult<List<CampaignWithFrontpageTypes>, Defect> validate(CampaignValidationContainer container,
                                                                               ValidationResult<List<CampaignWithFrontpageTypes>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);

        CampaignWithFrontpageTypesValidator validator = new CampaignWithFrontpageTypesValidator();

        vb.checkEachBy(validator);

        return vb.getResult();

    }



}
