package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeasurers;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithMeasurersValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMeasurersAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithMeasurers> {
    private final FeatureService featureService;

    public CampaignWithMeasurersAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithMeasurers> getTypeClass() {
        return CampaignWithMeasurers.class;
    }

    @Override
    public ValidationResult<List<CampaignWithMeasurers>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithMeasurers>, Defect> vr) {

        var validator = new CampaignWithMeasurersValidator(featureService.getEnabledForClientId(container.getClientId()));
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator::apply)
                .getResult();
    }
}
