package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMetrikaCounters;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithMetrikaCountersValidatorProvider;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMetrikaCountersAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithMetrikaCounters> {

    private final CampaignWithMetrikaCountersValidatorProvider validatorProvider;

    @Autowired
    public CampaignWithMetrikaCountersAddValidationTypeSupport(
            CampaignWithMetrikaCountersValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<CampaignWithMetrikaCounters> getTypeClass() {
        return CampaignWithMetrikaCounters.class;
    }

    @Override
    public ValidationResult<List<CampaignWithMetrikaCounters>, Defect> validate(
            CampaignValidationContainer container, ValidationResult<List<CampaignWithMetrikaCounters>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.campaignWithMetrikaCountersValidator(container, vr.getValue()))
                .getResult();
    }
}
