package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMinusKeywords;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithMinusKeywordsPreValidators;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithMinusKeywordsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMinusKeywordsAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithMinusKeywords> {
    @Override
    public Class<CampaignWithMinusKeywords> getTypeClass() {
        return CampaignWithMinusKeywords.class;
    }

    @Override
    public ValidationResult<List<CampaignWithMinusKeywords>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithMinusKeywords>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(CampaignWithMinusKeywordsPreValidators.CAMPAIGN_VALIDATOR)
                .getResult();
    }

    @Override
    public ValidationResult<List<CampaignWithMinusKeywords>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithMinusKeywords>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithMinusKeywordsValidator())
                .getResult();
    }
}
